/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketMessageWriter;
import org.kaazing.net.ws.impl.io.WsMessageWriterImpl;

public class WsOutputStreamImpl
extends OutputStream {
    private WsMessageWriterImpl _writer;
    private ByteArrayOutputStream _byteStream;
    private boolean _streamClosed;

    public WsOutputStreamImpl(WebSocketMessageWriter writer) {
        this._writer = (WsMessageWriterImpl)writer;
        this._byteStream = new ByteArrayOutputStream();
        this._streamClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        WsOutputStreamImpl wsOutputStreamImpl = this;
        synchronized (wsOutputStreamImpl) {
            if (this.isClosed()) {
                return;
            }
            this._streamClosed = true;
            this._byteStream.close();
            this._byteStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        WsOutputStreamImpl wsOutputStreamImpl = this;
        synchronized (wsOutputStreamImpl) {
            this._checkStreamClosed();
            if (this._byteStream.size() > 0) {
                byte[] bytes = this._byteStream.toByteArray();
                this._writer.writeBinary(ByteBuffer.wrap(bytes));
                this._byteStream.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        WsOutputStreamImpl wsOutputStreamImpl = this;
        synchronized (wsOutputStreamImpl) {
            this._checkStreamClosed();
            byte a = (byte)(b & 0xFF);
            this._byteStream.write(a);
        }
    }

    public boolean isClosed() {
        return this._streamClosed;
    }

    private void _checkStreamClosed() throws IOException {
        String s = "Cannot perform the operation on the OutputStream as it is closed";
        if (this._streamClosed) {
            throw new WebSocketException(s);
        }
    }
}

