/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl.legacy;

import java.io.IOException;
import java.util.logging.Logger;
import org.kaazing.net.sse.impl.legacy.EventSourceListener;

public class EventSource {
    private static final String CLASS_NAME = EventSource.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private EventSource _delegate;

    public EventSource() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    public ReadyState getReadyState() {
        return this._getDelegate().getReadyState();
    }

    public void connect(String eventSourceUrl) throws IOException {
        LOG.entering(CLASS_NAME, "connect", eventSourceUrl);
        this._getDelegate().connect(eventSourceUrl);
    }

    public void disconnect() {
        LOG.entering(CLASS_NAME, "disconnect");
        this._getDelegate().disconnect();
    }

    public void addEventSourceListener(EventSourceListener listener) {
        LOG.entering(CLASS_NAME, "addEventSourceListener", listener);
        this._getDelegate().addEventSourceListener(listener);
    }

    public void removeEventSourceListener(EventSourceListener listener) {
        LOG.entering(CLASS_NAME, "removeEventSourceListener", listener);
        this._getDelegate().removeEventSourceListener(listener);
    }

    private EventSource _getDelegate() {
        if (this._delegate != null) {
            return this._delegate;
        }
        try {
            this._delegate = (EventSource)Class.forName("org.kaazing.net.sse.impl.legacy.EventSourceImpl").newInstance();
        }
        catch (Exception e) {
            throw new Error("Cannot instantiate default EventSourceImpl");
        }
        return this._delegate;
    }

    public static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSED;

    }
}

