/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl;

import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.net.URI;
import org.kaazing.net.http.HttpRedirectPolicy;
import org.kaazing.net.impl.util.BlockingQueueImpl;
import org.kaazing.net.sse.SseEventReader;
import org.kaazing.net.sse.SseException;
import org.kaazing.net.sse.impl.AuthenticatedSseEventStream;
import org.kaazing.net.sse.impl.SseEventReaderImpl;
import org.kaazing.net.sse.impl.SseEventSourceImpl;
import org.kaazing.net.sse.impl.SseEventStream;
import org.kaazing.net.sse.impl.SseEventStreamListener;
import org.kaazing.net.sse.impl.SsePayload;

public class AuthenticatedSseEventSourceImpl
extends SseEventSourceImpl {
    private static final String _CLASS_NAME = AuthenticatedSseEventSourceImpl.class.getName();
    private static final TLog _LOG = TLog.get(AuthenticatedSseEventSourceImpl.class);
    private final SseEventReaderImpl _eventReader;
    private final BlockingQueueImpl<Object> _sharedQueue;
    private final URI _location;
    private SseEventStream _eventStream;
    private long _retryTimeout = 3000L;
    private HttpRedirectPolicy _redirectOption;
    private ReadyState _readyState;
    private SseException _exception;
    private ParticleCloud cloud;
    private SseEventStreamListener _eventStreamListener = new SseEventStreamListener(){

        @Override
        public void streamOpened() {
            _LOG.d("entering " + _CLASS_NAME + ".streamOpened");
            AuthenticatedSseEventSourceImpl.this.connectionOpened();
        }

        @Override
        public void messageReceived(String eventName, String message) {
            _LOG.d("entering " + _CLASS_NAME + ".messageReceived: " + message);
            AuthenticatedSseEventSourceImpl.this.messageArrived(eventName, message);
        }

        @Override
        public void streamErrored(Exception exception) {
            _LOG.d("entering " + _CLASS_NAME + ".streamErrored");
            AuthenticatedSseEventSourceImpl.this.connectionFailed(exception);
        }
    };

    public AuthenticatedSseEventSourceImpl(URI location, ParticleCloud cloud) {
        super(location);
        this.cloud = cloud;
        URI loc = location;
        if (location.getScheme().equalsIgnoreCase("sse")) {
            String fragment = location.getFragment();
            String schemeSpecificPart = location.getSchemeSpecificPart();
            if (fragment == null) {
                fragment = "";
            }
            loc = URI.create("http:" + schemeSpecificPart + fragment);
        }
        this._location = loc;
        this._readyState = ReadyState.CLOSED;
        this._sharedQueue = new BlockingQueueImpl();
        this._eventReader = new SseEventReaderImpl(this, this._sharedQueue);
    }

    @Override
    public synchronized void close() throws IOException {
        if (Py.list(ReadyState.CLOSED, ReadyState.CLOSING).contains((Object)this._readyState)) {
            _LOG.v("Event source is not connected");
            return;
        }
        this.setException(null);
        this._readyState = ReadyState.CLOSING;
        this._eventStream.stop();
        this._readyState = ReadyState.CLOSED;
        this.cleanupAfterClose();
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this._readyState != ReadyState.CLOSED) {
            String s = "Event source must be closed before connecting";
            throw new SseException(s);
        }
        this._eventStream = new AuthenticatedSseEventStream(this._location.toString(), this.cloud);
        this._eventStream.setListener(this._eventStreamListener);
        this._eventStream.setRetryTimeout(this._retryTimeout);
        this._eventReader.reset();
        this._readyState = ReadyState.CONNECTING;
        this.setException(null);
        this._eventStream.connect();
        SseException exception = this.getException();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public SseEventReader getEventReader() throws IOException {
        if (this._readyState != ReadyState.OPEN) {
            String s = "Cannot get the SseEventReader as the event source is not yet connected";
            throw new IOException(s);
        }
        return this._eventReader;
    }

    @Override
    public HttpRedirectPolicy getFollowRedirect() {
        return this._redirectOption;
    }

    @Override
    public long getRetryTimeout() {
        return this._retryTimeout;
    }

    @Override
    public void setFollowRedirect(HttpRedirectPolicy redirectOption) {
        this._redirectOption = redirectOption;
    }

    @Override
    public void setRetryTimeout(long millis) {
        this._retryTimeout = millis;
        if (this._eventStream != null) {
            this._eventStream.setRetryTimeout(millis);
        }
    }

    @Override
    public SseException getException() {
        return this._exception;
    }

    @Override
    public void setException(SseException exception) {
        this._exception = exception;
    }

    @Override
    public boolean isConnected() {
        return this._readyState == ReadyState.OPEN;
    }

    @Override
    public boolean isDisconnected() {
        return this._readyState == ReadyState.CLOSED;
    }

    @Override
    public BlockingQueueImpl<Object> getSharedQueue() {
        return this._sharedQueue;
    }

    private synchronized void connectionOpened() {
        this._readyState = ReadyState.OPEN;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageArrived(String eventName, String data) {
        if (this._readyState != ReadyState.OPEN) {
            return;
        }
        BlockingQueueImpl<Object> blockingQueueImpl = this._sharedQueue;
        synchronized (blockingQueueImpl) {
            try {
                this._sharedQueue.put(new SsePayload(eventName, data));
            }
            catch (InterruptedException ex) {
                _LOG.i(ex.getMessage(), ex);
            }
        }
    }

    private synchronized void connectionClosed(String reason) {
        this._readyState = ReadyState.CLOSED;
        if (reason != null) {
            this.setException(new SseException(reason));
        }
        this.cleanupAfterClose();
        this.notifyAll();
    }

    private synchronized void connectionFailed(Exception exception) {
        SseException ex = exception == null ? new SseException("Connection Failed") : new SseException(exception);
        this.setException(ex);
        this._readyState = ReadyState.CLOSED;
        this.cleanupAfterClose();
        this.notifyAll();
    }

    private synchronized void cleanupAfterClose() {
        try {
            this._eventReader.close();
        }
        catch (IOException ex) {
            _LOG.v(ex.getMessage(), ex);
        }
    }

    static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

