/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.kaazing.gateway.client.transport.Event;

public class MessageEvent
extends Event {
    private static final String CLASS_NAME = MessageEvent.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private ByteBuffer data;
    private String origin;
    private String lastEventId;
    private String messageType;

    public MessageEvent(ByteBuffer data, String origin, String lastEventId, String messageType) {
        super("message");
        LOG.entering(CLASS_NAME, "<init>", new Object[]{this.type, data, origin, lastEventId});
        this.data = data;
        this.origin = origin;
        this.lastEventId = lastEventId;
        this.messageType = messageType;
    }

    public ByteBuffer getData() {
        LOG.exiting(CLASS_NAME, "getData", this.data);
        return this.data;
    }

    public String getOrigin() {
        LOG.exiting(CLASS_NAME, "getOrigin", this.origin);
        return this.origin;
    }

    public String getLastEventId() {
        LOG.exiting(CLASS_NAME, "getLastEventId", this.lastEventId);
        return this.lastEventId;
    }

    public String getMessageType() {
        LOG.exiting(CLASS_NAME, "getMessageType", this.messageType);
        return this.messageType;
    }

    @Override
    public String toString() {
        String ret = "MessageEvent [type=" + this.type + " messageType=" + this.messageType + " data=" + this.data + " origin " + this.origin + " lastEventId=" + this.lastEventId + "{";
        for (Object a : this.params) {
            ret = ret + a + " ";
        }
        return ret + "}]";
    }
}

