/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.bridge.HttpRequestBridgeHandler;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestDelegateHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandlerAdapter;
import org.kaazing.gateway.client.impl.http.HttpRequestHandlerFactory;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestLoggingHandler;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.WebSocketTransportHandler;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class HttpRequestTransportHandler
extends HttpRequestHandlerAdapter {
    private static final String CLASS_NAME = HttpRequestTransportHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    public static HttpRequestHandlerFactory DEFAULT_FACTORY = new HttpRequestHandlerFactory(){

        @Override
        public HttpRequestHandler createHandler() {
            HttpRequestHandlerAdapter requestHandler = new HttpRequestTransportHandler();
            if (LOG.isLoggable(Level.FINE)) {
                HttpRequestLoggingHandler loggingHandler = new HttpRequestLoggingHandler();
                loggingHandler.setNextHandler(requestHandler);
                requestHandler = loggingHandler;
            }
            return requestHandler;
        }
    };

    @Override
    public void processOpen(HttpRequest request) {
        LOG.entering(CLASS_NAME, "processOpen: " + request);
        HttpRequestHandler transportHandler = WebSocketTransportHandler.useBridge(request.getUri().getURI()) ? new HttpRequestBridgeHandler() : new HttpRequestDelegateHandler();
        request.transportHandler = transportHandler;
        transportHandler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                HttpRequestTransportHandler.this.listener.requestReady(request);
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
                HttpRequestTransportHandler.this.listener.requestProgressed(request, payload);
            }

            @Override
            public void requestOpened(HttpRequest request) {
                HttpRequestTransportHandler.this.listener.requestOpened(request);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                HttpRequestTransportHandler.this.listener.requestLoaded(request, response);
            }

            @Override
            public void requestClosed(HttpRequest request) {
                HttpRequestTransportHandler.this.listener.requestClosed(request);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                HttpRequestTransportHandler.this.listener.requestAborted(request);
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                HttpRequestTransportHandler.this.listener.errorOccurred(request, exception);
            }
        });
        transportHandler.processOpen(request);
    }

    @Override
    public void processSend(HttpRequest request, WrappedByteBuffer buffer) {
        LOG.entering(CLASS_NAME, "processSend: " + request);
        HttpRequestHandler transportHandler = request.transportHandler;
        transportHandler.processSend(request, buffer);
    }

    @Override
    public void processAbort(HttpRequest request) {
        LOG.entering(CLASS_NAME, "processAbort: " + request);
        HttpRequestHandler transportHandler = request.transportHandler;
        transportHandler.processAbort(request);
    }
}

