/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.bridge;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.bridge.BridgeUtil;
import org.kaazing.gateway.client.impl.bridge.Proxy;
import org.kaazing.gateway.client.impl.bridge.ProxyListener;
import org.kaazing.gateway.client.impl.bridge.XoaEvent;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestUtil;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class HttpRequestBridgeHandler
implements HttpRequestHandler,
ProxyListener {
    private static final String CLASS_NAME = HttpRequestBridgeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private HttpRequestListener listener;

    public HttpRequestBridgeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    @Override
    public synchronized void processOpen(HttpRequest request) {
        LOG.entering(CLASS_NAME, "open", request);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("processOpen: " + request);
        }
        HttpURI uri = request.getUri();
        HttpRequest.Method method = request.getMethod();
        if (request.getProxy() != null) {
            throw new IllegalStateException("processOpen previously called with HttpRequest");
        }
        try {
            Proxy proxy = BridgeUtil.createProxy(uri.getURI(), this);
            proxy.setPeer(request);
            request.setProxy(proxy);
            Object[] params = new String[]{"HTTPREQUEST", uri.toString(), method.toString(), request.isAsync() ? "Y" : "N"};
            proxy.processEvent(XoaEvent.XoaEventKind.CREATE, params);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "While initializing HttpRequest proxy: " + e.getMessage(), e);
            this.listener.errorOccurred(request, e);
        }
    }

    private void handleRequestCreated(HttpRequest request) {
        LOG.entering(CLASS_NAME, "handleRequestCreated");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("handleRequestCreated: " + request);
        }
        request.setReadyState(HttpRequest.ReadyState.READY);
        try {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                String header = entry.getKey();
                String value = entry.getValue();
                HttpRequestUtil.validateHeader(header);
                Proxy proxy = (Proxy)request.getProxy();
                proxy.processEvent(XoaEvent.XoaEventKind.SETREQUESTHEADER, new String[]{header, value});
            }
            if (request.getMethod() == HttpRequest.Method.POST) {
                this.listener.requestReady(request);
            } else {
                this.processSend(request, null);
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.errorOccurred(request, e);
        }
    }

    @Override
    public void processSend(HttpRequest request, WrappedByteBuffer content) {
        LOG.entering(CLASS_NAME, "processSend", content);
        if (request.getReadyState() != HttpRequest.ReadyState.READY) {
            throw new IllegalStateException("HttpRequest must be in READY state to send");
        }
        request.setReadyState(HttpRequest.ReadyState.SENDING);
        ByteBuffer payload = content == null ? ByteBuffer.allocate(0) : ByteBuffer.wrap(content.array(), content.arrayOffset(), content.remaining());
        Proxy proxy = (Proxy)request.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.SEND, new Object[]{payload});
        request.setReadyState(HttpRequest.ReadyState.SENT);
    }

    private void handleRequestProgressed(HttpRequest request, WrappedByteBuffer payload) {
        LOG.entering(CLASS_NAME, "handleRequestProgressed", payload);
        request.setReadyState(HttpRequest.ReadyState.LOADING);
        try {
            this.listener.requestProgressed(request, payload);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.errorOccurred(request, e);
        }
    }

    private void handleRequestLoaded(HttpRequest request, WrappedByteBuffer responseBuffer) {
        LOG.entering(CLASS_NAME, "handleRequestLoaded", responseBuffer);
        request.setReadyState(HttpRequest.ReadyState.LOADED);
        HttpResponse response = request.getResponse();
        response.setBody(responseBuffer);
        try {
            this.listener.requestLoaded(request, response);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.errorOccurred(request, e);
        }
    }

    public static void parseResponseHeaders(HttpResponse response, String in) {
        LOG.entering(CLASS_NAME, "setResponseHeaders", in);
        String headers = in + "";
        int lf = headers.indexOf("\n");
        while (lf != -1) {
            String ret = headers.substring(0, lf);
            ret.trim();
            int colonAt = ret.indexOf(":");
            String name = ret.substring(0, colonAt);
            String value = ret.substring(colonAt + 1);
            response.setHeader(name, value);
            if (lf != headers.length()) {
                if ((headers = headers.substring(lf + 1)).length() == 0) {
                    headers.trim();
                }
            } else {
                headers = "";
            }
            if (headers.length() == 0) break;
            lf = headers.indexOf("\n");
        }
    }

    @Override
    public void eventReceived(Proxy proxy, XoaEvent.XoaEventKind eventKind, Object[] params) {
        LOG.entering(CLASS_NAME, "eventReceived", new Object[]{proxy, this, eventKind, params});
        HttpRequest request = (HttpRequest)proxy.getPeer();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "SOA <-- XOA:id = " + proxy.getHandlerId() + " name: " + (Object)((Object)eventKind) + " " + request);
        }
        switch (eventKind) {
            case OPEN: {
                this.handleRequestCreated(request);
                break;
            }
            case READYSTATECHANGE: {
                int responseCode;
                int state = Integer.parseInt((String)params[0]);
                if (state != 2) break;
                HttpResponse response = new HttpResponse();
                request.setResponse(response);
                if (params.length > 1 && (responseCode = Integer.parseInt((String)params[1])) != 0) {
                    response.setStatusCode(responseCode);
                    response.setMessage((String)params[2]);
                    HttpRequestBridgeHandler.parseResponseHeaders(response, (String)params[3]);
                }
                request.setReadyState(HttpRequest.ReadyState.OPENED);
                this.listener.requestOpened(request);
                break;
            }
            case PROGRESS: {
                WrappedByteBuffer messageBuffer = WrappedByteBuffer.wrap((ByteBuffer)params[0]);
                this.handleRequestProgressed(request, messageBuffer);
                break;
            }
            case LOAD: {
                WrappedByteBuffer responseBuffer = WrappedByteBuffer.wrap((ByteBuffer)params[0]);
                this.handleRequestLoaded(request, responseBuffer);
                break;
            }
            case CLOSED: {
                proxy = null;
                this.listener.requestClosed(request);
                break;
            }
            case ERROR: {
                proxy = null;
                String s = "HTTP Bridge Handler: ERROR event received";
                this.handleErrorOccurred(request, new IllegalStateException(s));
                break;
            }
            default: {
                throw new IllegalArgumentException("INVALID_STATE_ERR");
            }
        }
    }

    private void handleErrorOccurred(HttpRequest request, Exception exception) {
        request.setReadyState(HttpRequest.ReadyState.ERROR);
        this.listener.errorOccurred(request, exception);
    }

    @Override
    public void processAbort(HttpRequest request) {
        if (request.getReadyState() == HttpRequest.ReadyState.UNSENT) {
            throw new IllegalStateException("INVALID_STATE_ERR");
        }
        Proxy proxy = (Proxy)request.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.ABORT, XoaEvent.EMPTY_ARGS);
    }

    @Override
    public void setListener(HttpRequestListener listener) {
        this.listener = listener;
    }
}

