/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.net.impl.util.BlockingQueueImpl;
import org.kaazing.net.ws.WebSocketException;
import org.kaazing.net.ws.WebSocketMessageReader;
import org.kaazing.net.ws.WebSocketMessageType;
import org.kaazing.net.ws.impl.WebSocketImpl;

public class WsMessageReaderImpl
extends WebSocketMessageReader {
    private static final String _CLASS_NAME = WsMessageReaderImpl.class.getName();
    private static final Logger _LOG = Logger.getLogger(_CLASS_NAME);
    private final BlockingQueueImpl<Object> _sharedQueue;
    private final WebSocketImpl _webSocket;
    private Object _payload;
    private WebSocketMessageType _messageType;
    private boolean _closed = false;

    public WsMessageReaderImpl(WebSocketImpl webSocket, BlockingQueueImpl<Object> sharedQueue) {
        if (webSocket == null) {
            String s = "Null webSocket passed in";
            throw new IllegalArgumentException(s);
        }
        if (sharedQueue == null) {
            String s = "Null sharedQueue passed in";
            throw new IllegalArgumentException(s);
        }
        this._webSocket = webSocket;
        this._sharedQueue = sharedQueue;
    }

    @Override
    public ByteBuffer getBinary() throws IOException {
        if (this._messageType == null) {
            return null;
        }
        if (this._messageType == WebSocketMessageType.EOS) {
            String s = "End of stream has reached as the connection has been closed";
            throw new WebSocketException(s);
        }
        if (this._messageType != WebSocketMessageType.BINARY) {
            String s = "Invalid WebSocketMessageType: Cannot decode the payload as a binary message";
            throw new WebSocketException(s);
        }
        return ByteBuffer.wrap(((ByteBuffer)this._payload).array());
    }

    @Override
    public CharSequence getText() throws IOException {
        if (this._messageType == null) {
            return null;
        }
        if (this._messageType == WebSocketMessageType.EOS) {
            String s = "End of stream has reached as the connection has been closed";
            throw new WebSocketException(s);
        }
        if (this._messageType != WebSocketMessageType.TEXT) {
            String s = "Invalid WebSocketMessageType: Cannot decode the payload as a text message";
            throw new WebSocketException(s);
        }
        return String.valueOf(((String)this._payload).toCharArray());
    }

    @Override
    public WebSocketMessageType getType() {
        return this._messageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketMessageType next() throws IOException {
        if (this.isClosed()) {
            String s = "Cannot read as the MessageReader is closed";
            throw new WebSocketException(s);
        }
        WsMessageReaderImpl wsMessageReaderImpl = this;
        synchronized (wsMessageReaderImpl) {
            if (this._sharedQueue.size() == 0 && !this._webSocket.isConnected()) {
                this._messageType = WebSocketMessageType.EOS;
                return this._messageType;
            }
            try {
                this._payload = null;
                this._webSocket.setException(null);
                this._payload = this._sharedQueue.take();
            }
            catch (InterruptedException ex) {
                _LOG.log(Level.FINE, ex.getMessage());
            }
            if (this._payload == null) {
                String s = "MessageReader has been interrupted maybe the connection is closed";
                _LOG.log(Level.FINE, _CLASS_NAME, s);
                this._messageType = WebSocketMessageType.EOS;
                return this._messageType;
            }
            this._messageType = this._payload.getClass() == String.class ? WebSocketMessageType.TEXT : WebSocketMessageType.BINARY;
        }
        return this._messageType;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (!this._webSocket.isDisconnected()) {
            String s = "Can't close the MessageReader if the WebSocket is still connected";
            throw new WebSocketException(s);
        }
        this._sharedQueue.done();
        this._closed = true;
    }

    public void reset() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (!this._webSocket.isDisconnected()) {
            String s = "Can't reset the MessageReader if the WebSocket is still connected";
            throw new WebSocketException(s);
        }
        this._sharedQueue.reset();
        this._payload = null;
        this._messageType = null;
    }

    public boolean isClosed() {
        return this._closed;
    }
}

