/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.http.HttpRedirectPolicy;
import org.kaazing.net.ws.WebSocket;
import org.kaazing.net.ws.WebSocketExtension;
import org.kaazing.net.ws.WebSocketFactory;
import org.kaazing.net.ws.impl.WebSocketImpl;
import org.kaazing.net.ws.impl.WsExtensionParameterValuesSpiImpl;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionFactorySpi;

public final class DefaultWebSocketFactory
extends WebSocketFactory {
    private static final Map<String, WebSocketExtensionFactorySpi> _extensionFactories;
    private final Map<String, WsExtensionParameterValuesSpiImpl> _parameters = new HashMap<String, WsExtensionParameterValuesSpiImpl>();
    private HttpRedirectPolicy _redirectOption;
    private Collection<String> _supportedExtensions = new HashSet<String>();
    private Collection<String> _enabledExtensions;
    private ChallengeHandler _challengeHandler;
    private int _connectTimeout = 0;

    public DefaultWebSocketFactory() {
        this._supportedExtensions.addAll(_extensionFactories.keySet());
        this._redirectOption = HttpRedirectPolicy.ALWAYS;
    }

    @Override
    public WebSocket createWebSocket(URI location) throws URISyntaxException {
        return this.createWebSocket(location, null);
    }

    @Override
    public WebSocket createWebSocket(URI location, String ... protocols) throws URISyntaxException {
        HashSet<String> enabledProtocols = null;
        ArrayList<String> enabledExtensions = null;
        if (protocols != null) {
            enabledProtocols = new HashSet<String>(Arrays.asList(protocols));
        }
        if (this._enabledExtensions != null) {
            enabledExtensions = new ArrayList<String>(this._enabledExtensions);
        }
        HashMap<String, WsExtensionParameterValuesSpiImpl> enabledParams = new HashMap<String, WsExtensionParameterValuesSpiImpl>();
        enabledParams.putAll(this._parameters);
        WebSocketImpl ws = new WebSocketImpl(location, _extensionFactories, this._redirectOption, enabledExtensions, enabledProtocols, enabledParams, this._challengeHandler, this._connectTimeout);
        return ws;
    }

    @Override
    public int getDefaultConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public ChallengeHandler getDefaultChallengeHandler() {
        return this._challengeHandler;
    }

    @Override
    public Collection<String> getDefaultEnabledExtensions() {
        return this._enabledExtensions == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._enabledExtensions);
    }

    @Override
    public HttpRedirectPolicy getDefaultRedirectPolicy() {
        return this._redirectOption;
    }

    @Override
    public <T> T getDefaultParameter(WebSocketExtension.Parameter<T> parameter) {
        String extName = parameter.extension().name();
        WsExtensionParameterValuesSpiImpl paramValues = this._parameters.get(extName);
        if (paramValues == null) {
            return null;
        }
        return paramValues.getParameterValue(parameter);
    }

    @Override
    public Collection<String> getSupportedExtensions() {
        return this._supportedExtensions == null ? Collections.emptySet() : Collections.unmodifiableCollection(this._supportedExtensions);
    }

    @Override
    public void setDefaultChallengeHandler(ChallengeHandler challengeHandler) {
        this._challengeHandler = challengeHandler;
    }

    @Override
    public void setDefaultConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    @Override
    public void setDefaultEnabledExtensions(Collection<String> extensions) {
        if (extensions == null) {
            this._enabledExtensions = extensions;
            return;
        }
        Collection<String> supportedExtns = this.getSupportedExtensions();
        for (String extension : extensions) {
            if (!supportedExtns.contains(extension)) {
                String s = String.format("'%s' is not a supported extension", extension);
                throw new IllegalStateException(s);
            }
            if (this._enabledExtensions == null) {
                this._enabledExtensions = new ArrayList<String>();
            }
            this._enabledExtensions.add(extension);
        }
    }

    @Override
    public void setDefaultRedirectPolicy(HttpRedirectPolicy redirectOption) {
        this._redirectOption = redirectOption;
    }

    @Override
    public <T> void setDefaultParameter(WebSocketExtension.Parameter<T> parameter, T value) {
        String extensionName = parameter.extension().name();
        WsExtensionParameterValuesSpiImpl parameterValues = this._parameters.get(extensionName);
        if (parameterValues == null) {
            parameterValues = new WsExtensionParameterValuesSpiImpl();
            this._parameters.put(extensionName, parameterValues);
        }
        parameterValues.setParameterValue(parameter, value);
    }

    static {
        Class<WebSocketExtensionFactorySpi> clazz = WebSocketExtensionFactorySpi.class;
        ServiceLoader<WebSocketExtensionFactorySpi> loader = ServiceLoader.load(clazz);
        HashMap<String, WebSocketExtensionFactorySpi> factories = new HashMap<String, WebSocketExtensionFactorySpi>();
        for (WebSocketExtensionFactorySpi factory : loader) {
            String extensionName = factory.getExtensionName();
            if (extensionName == null) continue;
            factories.put(extensionName, factory);
        }
        _extensionFactories = Collections.unmodifiableMap(factories);
    }
}

