/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.kaazing.net.http.HttpRedirectPolicy;
import org.kaazing.net.sse.SseEventSource;
import org.kaazing.net.sse.SseEventSourceFactory;
import org.kaazing.net.sse.impl.SseEventSourceImpl;

public class DefaultEventSourceFactory
extends SseEventSourceFactory {
    private long _retryTimeout = 3000L;
    private HttpRedirectPolicy _redirectOption = HttpRedirectPolicy.ALWAYS;

    @Override
    public SseEventSource createEventSource(URI location) throws URISyntaxException {
        String scheme = location.getScheme();
        if (!(scheme.toLowerCase().equals("sse") || scheme.toLowerCase().equals("http") || scheme.toLowerCase().equals("https"))) {
            String s = String.format("Incorrect scheme or protocol '%s'", scheme);
            throw new URISyntaxException(location.toString(), s);
        }
        SseEventSourceImpl eventSource = new SseEventSourceImpl(location);
        eventSource.setFollowRedirect(this._redirectOption);
        eventSource.setRetryTimeout(this._retryTimeout);
        return eventSource;
    }

    @Override
    public HttpRedirectPolicy getDefaultFollowRedirect() {
        return this._redirectOption;
    }

    @Override
    public long getDefaultRetryTimeout() {
        return this._retryTimeout;
    }

    @Override
    public void setDefaultFollowRedirect(HttpRedirectPolicy redirectOption) {
        this._redirectOption = redirectOption;
    }

    @Override
    public void setDefaultRetryTimeout(long millis) {
        this._retryTimeout = millis;
    }
}

