/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport.ws;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.kaazing.gateway.client.transport.ws.FrameProcessorListener;
import org.kaazing.gateway.client.transport.ws.WsFrameEncodingSupport;

public class FrameProcessor {
    private static final String CLASS_NAME = FrameProcessor.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    FrameProcessorListener listener;
    DecodingState state;
    WsFrameEncodingSupport.Opcode opcode;
    int dataLength;
    Boolean masked;
    int maskkey;
    ByteBuffer payLoadLengthBuf;
    ByteBuffer maskkeyBuf;
    Boolean fin;
    ByteBuffer data;

    FrameProcessor(FrameProcessorListener listener) {
        this.listener = listener;
        this.state = DecodingState.START_OF_FRAME;
    }

    boolean process(InputStream inputStream) throws IOException {
        LOG.entering(CLASS_NAME, "process");
        while (true) {
            switch (this.state) {
                case START_OF_FRAME: {
                    int b = inputStream.read();
                    if (b == -1) {
                        return false;
                    }
                    this.fin = (b & 0x80) != 0;
                    this.opcode = WsFrameEncodingSupport.Opcode.getById(b & 0xF);
                    this.state = DecodingState.READING_PAYLOADLENGTH;
                    break;
                }
                case READING_PAYLOADLENGTH: {
                    int b = inputStream.read();
                    if (b == -1) {
                        return false;
                    }
                    this.masked = (b & 0x80) != 0;
                    if (this.masked.booleanValue()) {
                        this.maskkeyBuf = ByteBuffer.allocate(4);
                    }
                    this.dataLength = b & 0x7F;
                    if (this.dataLength == 126) {
                        this.state = DecodingState.READING_PAYLOADLENGTH_EXT;
                        this.payLoadLengthBuf = ByteBuffer.allocate(4);
                        this.payLoadLengthBuf.put(new byte[]{0, 0});
                        break;
                    }
                    if (this.dataLength == 127) {
                        this.state = DecodingState.READING_PAYLOADLENGTH_EXT;
                        this.payLoadLengthBuf = ByteBuffer.allocate(8);
                        break;
                    }
                    this.state = DecodingState.READING_MASK_KEY;
                    break;
                }
                case READING_PAYLOADLENGTH_EXT: {
                    byte[] bytes = new byte[this.payLoadLengthBuf.remaining()];
                    int num = inputStream.read(bytes);
                    if (num == -1) {
                        return false;
                    }
                    this.payLoadLengthBuf.put(bytes, 0, num);
                    if (this.payLoadLengthBuf.hasRemaining()) break;
                    this.payLoadLengthBuf.flip();
                    this.dataLength = this.payLoadLengthBuf.capacity() == 4 ? this.payLoadLengthBuf.getInt() : (int)this.payLoadLengthBuf.getLong();
                    this.state = DecodingState.READING_MASK_KEY;
                    break;
                }
                case READING_MASK_KEY: {
                    if (!this.masked.booleanValue()) {
                        this.data = ByteBuffer.allocate(this.dataLength);
                        this.state = DecodingState.READING_PAYLOAD;
                        break;
                    }
                    byte[] bytes = new byte[this.maskkeyBuf.remaining()];
                    int num = inputStream.read(bytes);
                    if (num == -1) {
                        return false;
                    }
                    this.maskkeyBuf.put(bytes, 0, num);
                    if (this.maskkeyBuf.hasRemaining()) break;
                    this.maskkeyBuf.flip();
                    this.maskkey = this.maskkeyBuf.getInt();
                    this.data = ByteBuffer.allocate(this.dataLength);
                    this.state = DecodingState.READING_PAYLOAD;
                    break;
                }
                case READING_PAYLOAD: {
                    if (this.dataLength == 0) {
                        this.state = DecodingState.END_OF_FRAME;
                        break;
                    }
                    byte[] bytes = new byte[this.data.remaining()];
                    int num = inputStream.read(bytes);
                    if (num == -1) {
                        return false;
                    }
                    this.data.put(bytes, 0, num);
                    if (this.data.hasRemaining()) break;
                    this.data.flip();
                    this.state = DecodingState.END_OF_FRAME;
                    break;
                }
                case END_OF_FRAME: {
                    switch (this.opcode) {
                        case BINARY: {
                            if (this.masked.booleanValue()) {
                                WsFrameEncodingSupport.unmask(this.data, this.maskkey);
                            }
                            this.listener.messageReceived(this.data, "BINARY");
                            break;
                        }
                        case TEXT: {
                            if (this.masked.booleanValue()) {
                                WsFrameEncodingSupport.unmask(this.data, this.maskkey);
                            }
                            this.listener.messageReceived(this.data, "TEXT");
                            break;
                        }
                        case PING: {
                            this.listener.messageReceived(this.data, "PING");
                            break;
                        }
                        case PONG: {
                            break;
                        }
                        case CLOSE: {
                            this.listener.messageReceived(this.data, "CLOSE");
                        }
                    }
                    this.state = DecodingState.START_OF_FRAME;
                }
            }
        }
    }

    static enum DecodingState {
        START_OF_FRAME,
        READING_PAYLOADLENGTH,
        READING_PAYLOADLENGTH_EXT,
        READING_MASK_KEY,
        READING_PAYLOAD,
        END_OF_FRAME;

    }
}

