/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.ws;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.util.WSCompositeURI;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.impl.ws.WebSocketSelectedChannel;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.impl.util.ResumableTimer;

public class WebSocketCompositeChannel
extends WebSocketChannel {
    public WebSocketSelectedChannel selectedChannel;
    String[] requestedProtocols;
    protected List<String> connectionStrategies = new LinkedList<String>();
    protected ReadyState readyState = ReadyState.CLOSED;
    protected boolean closing = false;
    private Object webSocket;
    private String compositeScheme;
    private ChallengeHandler challengeHandler;
    private ResumableTimer connectTimer;

    public WebSocketCompositeChannel(WSCompositeURI location) {
        super(location.getWSEquivalent());
        this.compositeScheme = location.getScheme();
    }

    public ChallengeHandler getChallengeHandler() {
        return this.challengeHandler;
    }

    public void setChallengeHandler(ChallengeHandler challengeHandler) {
        this.challengeHandler = challengeHandler;
    }

    public ReadyState getReadyState() {
        return this.readyState;
    }

    public Object getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(Object webSocket) {
        this.webSocket = webSocket;
    }

    public String getOrigin() {
        URI uri = this.getLocation().getURI();
        return uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
    }

    public URI getURL() {
        return this.getLocation().getURI();
    }

    public String getCompositeScheme() {
        return this.compositeScheme;
    }

    public String getNextStrategy() {
        if (this.connectionStrategies.isEmpty()) {
            return null;
        }
        return this.connectionStrategies.remove(0);
    }

    public synchronized ResumableTimer getConnectTimer() {
        return this.connectTimer;
    }

    public synchronized void setConnectTimer(ResumableTimer connectTimer) {
        if (this.connectTimer != null) {
            this.connectTimer.cancel();
            this.connectTimer = null;
        }
        this.connectTimer = connectTimer;
    }
}

