/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import io.particle.android.sdk.utils.TLog;
import java.io.Closeable;
import java.io.IOException;

public class EZ {
    private static final TLog log = TLog.get(EZ.class);

    public static void runOnMainThread(@NonNull Runnable runnable) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(runnable);
    }

    public static void runOnMainThreadDelayed(long delayInMillis, @NonNull Runnable runnable) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(runnable, delayInMillis);
    }

    public static void runAsync(final @NonNull Runnable runnable) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                runnable.run();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public static void threadSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.e("Thread interrupted: ", e);
        }
    }

    public static boolean isUsingOlderWifiStack() {
        return Build.VERSION.SDK_INT < 20;
    }

    public static <T> T getCallbacksOrThrow(@NonNull Fragment frag, @NonNull Class<T> callbacks) {
        Fragment parent = frag.getParentFragment();
        if (parent != null && callbacks.isInstance(parent)) {
            return (T)parent;
        }
        FragmentActivity activity = frag.getActivity();
        if (activity != null && callbacks.isInstance(activity)) {
            return (T)activity;
        }
        throw new ClassCastException("This fragment's activity or parent fragment must implement " + callbacks.getCanonicalName());
    }

    public static Uri buildRawResourceUri(Context ctx, String filename) {
        return Uri.parse((String)String.format("android.resource://%s/raw/%s", ctx.getPackageName(), EZ.removeExtension(filename)));
    }

    public static void closeThisThingOrMaybeDont(@Nullable Closeable closeable) {
        if (closeable == null) {
            log.d("Can't close closable, arg was null.");
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.d("Couldn't close closable, but that's apparently OK.  Error was: " + e.getMessage());
        }
    }

    @Nullable
    private static String removeExtension(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        int indexOfExtension = filename.lastIndexOf(".");
        if (indexOfExtension == -1) {
            return filename;
        }
        return filename.substring(0, indexOfExtension);
    }
}

