/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.app.Activity;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;

public class Async {
    private static final TLog log = TLog.get(Async.class);

    public static <T> AsyncApiWorker<ParticleCloud, T> executeAsync(@NonNull ParticleCloud particleCloud, @NonNull ApiWork<ParticleCloud, T> work) {
        return (AsyncApiWorker)new AsyncApiWorker(particleCloud, work).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static <T> AsyncApiWorker<ParticleDevice, T> executeAsync(@NonNull ParticleDevice particleDevice, @NonNull ApiWork<ParticleDevice, T> work) {
        return (AsyncApiWorker)new AsyncApiWorker(particleDevice, work).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static class AsyncApiWorker<ApiCaller, Result>
    extends AsyncTask<Void, Void, Result> {
        private final ApiCaller caller;
        private final ApiWork<ApiCaller, Result> work;
        private Activity activity;
        private volatile ParticleCloudException exception;
        public volatile IOException ioException;

        private AsyncApiWorker(ApiCaller caller, ApiWork<ApiCaller, Result> work) {
            this.caller = caller;
            this.work = work;
        }

        public AsyncApiWorker<ApiCaller, Result> andIgnoreCallbacksIfActivityIsFinishing(Activity activity) {
            this.activity = activity;
            return this;
        }

        protected Result doInBackground(Void ... voids) {
            try {
                return this.work.callApi(this.caller);
            }
            catch (ParticleCloudException e) {
                this.exception = e;
                return null;
            }
            catch (IOException e) {
                this.ioException = e;
                return null;
            }
        }

        protected void onCancelled() {
            if (this.shouldCallCallbacks()) {
                this.work.onTaskFinished();
                this.work.onCancelled();
            }
        }

        protected void onPostExecute(Result result) {
            if (!this.shouldCallCallbacks()) {
                return;
            }
            this.work.onTaskFinished();
            if (this.exception == null && this.ioException == null) {
                this.work.onSuccess(result);
            } else {
                if (this.exception == null) {
                    this.exception = new ParticleCloudException(this.ioException);
                }
                log.e("Error calling API: " + this.exception.getBestMessage(), this.exception);
                this.work.onFailure(this.exception);
            }
        }

        private boolean shouldCallCallbacks() {
            boolean shouldCall;
            if (this.activity == null) {
                return true;
            }
            boolean bl = shouldCall = !this.activity.isFinishing();
            if (!shouldCall) {
                log.d("Refusing to call callbacks, was told to ignore them if the activity was finishing");
            }
            return shouldCall;
        }
    }

    public static abstract class ApiProcedure<ApiCaller>
    extends ApiWork<ApiCaller, Void> {
        @Override
        public void onSuccess(Void voyd) {
        }
    }

    public static abstract class ApiWork<ApiCaller, Result> {
        public abstract Result callApi(@NonNull ApiCaller var1) throws ParticleCloudException, IOException;

        public abstract void onSuccess(Result var1);

        public abstract void onFailure(ParticleCloudException var1);

        public void onTaskFinished() {
        }

        public void onCancelled() {
        }
    }
}

