/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.ApiFactory;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.R;
import io.particle.android.sdk.cloud.SDKGlobals;
import java.util.concurrent.Executors;

class SDKProvider {
    private final Context ctx;
    private final ApiDefs.CloudApi cloudApi;
    private final ApiDefs.IdentityApi identityApi;
    private final ParticleCloud particleCloud;
    private final TokenGetterDelegateImpl tokenGetter;

    SDKProvider(Context context, @Nullable ApiFactory.OauthBasicAuthCredentialsProvider oAuthCredentialsProvider) {
        this.ctx = context.getApplicationContext();
        if (oAuthCredentialsProvider == null) {
            oAuthCredentialsProvider = new ApiFactory.ResourceValueBasicAuthCredentialsProvider(this.ctx, R.string.oauth_client_id, R.string.oauth_client_secret);
        }
        this.tokenGetter = new TokenGetterDelegateImpl();
        ApiFactory apiFactory = new ApiFactory(this.ctx, this.tokenGetter, oAuthCredentialsProvider);
        this.cloudApi = apiFactory.buildNewCloudApi();
        this.identityApi = apiFactory.buildNewIdentityApi();
        this.particleCloud = this.buildCloud(apiFactory);
    }

    ApiDefs.CloudApi getCloudApi() {
        return this.cloudApi;
    }

    ApiDefs.IdentityApi getIdentityApi() {
        return this.identityApi;
    }

    ParticleCloud getParticleCloud() {
        return this.particleCloud;
    }

    private ParticleCloud buildCloud(ApiFactory apiFactory) {
        SDKGlobals.init(this.ctx);
        ParticleCloud cloud = new ParticleCloud(apiFactory.getApiUri(), this.cloudApi, this.identityApi, SDKGlobals.getAppDataStorage(), LocalBroadcastManager.getInstance((Context)this.ctx), apiFactory.getGsonInstance(), Executors.newCachedThreadPool());
        this.tokenGetter.cloud = cloud;
        return cloud;
    }

    private static class TokenGetterDelegateImpl
    implements ApiFactory.TokenGetterDelegate {
        private volatile ParticleCloud cloud;

        private TokenGetterDelegateImpl() {
        }

        @Override
        public String getTokenValue() {
            return this.cloud.getAccessToken();
        }
    }
}

