/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.particle.android.sdk.cloud.ApiFactory;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.SDKProvider;
import io.particle.android.sdk.utils.TLog;
import net.danlew.android.joda.JodaTimeAndroid;

public class ParticleCloudSDK {
    private static final TLog log = TLog.get(ParticleCloudSDK.class);
    private static ParticleCloudSDK instance;
    private final SDKProvider sdkProvider;

    public static void init(@NonNull Context ctx) {
        ParticleCloudSDK.initWithOauthCredentialsProvider(ctx, null);
    }

    public static void initWithOauthCredentialsProvider(@NonNull Context ctx, @Nullable ApiFactory.OauthBasicAuthCredentialsProvider oauthProvider) {
        Context appContext = ctx.getApplicationContext();
        JodaTimeAndroid.init((Context)appContext);
        SDKProvider sdkProvider = new SDKProvider(appContext, oauthProvider);
        ParticleCloudSDK.initWithSdkProvider(sdkProvider);
    }

    public static ParticleCloud getCloud() {
        ParticleCloudSDK.verifyInitCalled();
        return ParticleCloudSDK.instance.sdkProvider.getParticleCloud();
    }

    static void initWithSdkProvider(SDKProvider sdkProvider) {
        if (instance != null) {
            log.w("Calling ParticleCloudSDK.init() more than once does not re-initialize the SDK.");
            return;
        }
        instance = new ParticleCloudSDK(sdkProvider);
    }

    static boolean isInitialized() {
        return instance != null;
    }

    static SDKProvider getSdkProvider() {
        ParticleCloudSDK.verifyInitCalled();
        return ParticleCloudSDK.instance.sdkProvider;
    }

    static void verifyInitCalled() {
        if (!ParticleCloudSDK.isInitialized()) {
            throw new IllegalStateException("init not called before using the Particle SDK. Are you calling ParticleCloudSDK.init() in your Application.onCreate()?");
        }
    }

    private ParticleCloudSDK(SDKProvider sdkProvider) {
        this.sdkProvider = sdkProvider;
    }
}

