/**
 * Copyright (c) 2007-2014 Kaazing Corporation. All rights reserved.
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.kaazing.net.sse.impl.legacy;

import java.util.EventObject;
import java.util.logging.Logger;

/**
 * This class represents events generated by the EventSource object
 * 
 */
public class EventSourceEvent extends EventObject {
    private static final String CLASS_NAME = EventSourceEvent.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    private static final long serialVersionUID = -3654347840399311101L;
    private final Type type;
    private final String data;

    /**
     * Type of the EventSourceEvent.
     */
    public enum Type {
        OPEN, MESSAGE, ERROR
    }

    /**
     * 
     * @param source
     * @param type
     */
    public EventSourceEvent(Object source, Type type) {
        this(source, type, null);
    }

    public EventSourceEvent(Object source, Type type, String message) {
        super(source);
        LOG.entering(CLASS_NAME, "<init>", new Object[] { source, type, message });
        this.type = type;
        this.data = message;
    }

    /**
     * Get type of the EventSourceEvent OPEN, MESSAGE or ERROR
     * 
     * @return the EventSourceEvent type
     */
    public Type getType() {
        LOG.exiting(CLASS_NAME, "getType", type);
        return type;
    }

    /**
     * Returns the message data delivered by the event source
     * 
     * @return the message data
     */
    public String getData() {
        LOG.exiting(CLASS_NAME, "getData", data);
        return data;
    }

}
