/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl;

import io.particle.android.sdk.cloud.ParticleCloud;
import java.net.URI;
import java.net.URISyntaxException;
import org.kaazing.net.sse.SseEventSource;
import org.kaazing.net.sse.impl.AuthenticatedSseEventSourceImpl;
import org.kaazing.net.sse.impl.DefaultEventSourceFactory;

public class AuthenticatedEventSourceFactory
extends DefaultEventSourceFactory {
    private final ParticleCloud cloud;

    public AuthenticatedEventSourceFactory(ParticleCloud cloud) {
        this.cloud = cloud;
    }

    public SseEventSource createEventSource(URI location) throws URISyntaxException {
        String scheme = location.getScheme();
        if (!(scheme.toLowerCase().equals("sse") || scheme.toLowerCase().equals("http") || scheme.toLowerCase().equals("https"))) {
            String s = String.format("Incorrect scheme or protocol '%s'", scheme);
            throw new URISyntaxException(location.toString(), s);
        }
        AuthenticatedSseEventSourceImpl eventSource = new AuthenticatedSseEventSourceImpl(location, this.cloud);
        eventSource.setFollowRedirect(this.getDefaultFollowRedirect());
        eventSource.setRetryTimeout(this.getDefaultRetryTimeout());
        return eventSource;
    }
}

