/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.persistance;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;

public class AppDataStorage {
    private static final String KEY_USER_HAS_CLAIMED_DEVICES = "KEY_USER_HAS_CLAIMED_DEVICES";
    private final SharedPreferences sharedPrefs;

    public AppDataStorage(@NonNull Context ctx) {
        ctx = ctx.getApplicationContext();
        this.sharedPrefs = ctx.getSharedPreferences("spark_sdk_prefs", 0);
    }

    public void saveUserHasClaimedDevices(boolean value) {
        this.sharedPrefs.edit().putBoolean(KEY_USER_HAS_CLAIMED_DEVICES, value).apply();
    }

    public boolean getUserHasClaimedDevices() {
        return this.sharedPrefs.getBoolean(KEY_USER_HAS_CLAIMED_DEVICES, false);
    }

    public void resetUserHasClaimedDevices() {
        this.sharedPrefs.edit().remove(KEY_USER_HAS_CLAIMED_DEVICES).apply();
    }
}

