/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.RetrofitError;

public class ParticleCloudException
extends Exception {
    private static final TLog log = TLog.get(ParticleCloudException.class);
    private final RetrofitError innerError;
    private final ResponseErrorData responseData;
    private boolean checkedForServerErrorMsg = false;
    private String serverErrorMessage;

    public ParticleCloudException(Exception exception) {
        super(exception);
        this.innerError = RetrofitError.unexpectedError((String)"(URL UNKNOWN)", (Throwable)exception);
        this.responseData = null;
    }

    ParticleCloudException(RetrofitError innerError) {
        this.innerError = innerError;
        this.responseData = this.buildResponseData(innerError);
    }

    public ResponseErrorData getResponseData() {
        return this.responseData;
    }

    public Kind getKind() {
        return Kind.valueOf(this.innerError.getKind().toString());
    }

    public String getServerErrorMsg() {
        if (!this.checkedForServerErrorMsg) {
            this.checkedForServerErrorMsg = true;
            this.serverErrorMessage = this.loadServerErrorMsg();
        }
        return this.serverErrorMessage;
    }

    public String getBestMessage() {
        if (this.getKind() == Kind.NETWORK) {
            return "Unable to connect to the server.";
        }
        if (this.getKind() == Kind.UNEXPECTED) {
            return "Unknown error communicating with server.";
        }
        String serverMsg = this.getServerErrorMsg();
        return serverMsg == null ? this.getMessage() : serverMsg;
    }

    private String loadServerErrorMsg() {
        if (this.responseData == null || this.responseData.getBody() == null) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(this.responseData.getBody());
            if (jsonObject.has("error_description")) {
                return jsonObject.getString("error_description");
            }
            if (jsonObject.has("errors")) {
                List<String> errors = this.getErrors(jsonObject);
                return errors.isEmpty() ? null : StringUtils.join((Object[])new Object[]{"\n", errors});
            }
            if (jsonObject.has("error")) {
                return jsonObject.getString("error");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private List<String> getErrors(JSONObject jsonObject) throws JSONException {
        List<String> errors = Py.list();
        JSONArray jsonArray = jsonObject.getJSONArray("errors");
        if (jsonArray == null || jsonArray.length() == 0) {
            return errors;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            String msg = null;
            JSONObject msgObj = jsonArray.optJSONObject(i);
            msg = msgObj != null ? msgObj.getString("message") : jsonArray.get(i).toString();
            errors.add(msg);
        }
        return errors;
    }

    private ResponseErrorData buildResponseData(RetrofitError error) {
        if (error.getResponse() == null) {
            return null;
        }
        InputStream in = null;
        if (error.getResponse().getBody() != null) {
            try {
                in = error.getResponse().getBody().in();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ResponseErrorData(error.getResponse().getStatus(), in);
    }

    public static class ResponseErrorData {
        private final int httpStatusCode;
        private final InputStream httpBodyInputStream;
        private String lazyLoadedBody;
        private boolean isBodyLoaded;

        ResponseErrorData(int httpStatusCode, InputStream httpBodyInputStream) {
            this.httpStatusCode = httpStatusCode;
            this.httpBodyInputStream = httpBodyInputStream;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public String getBody() {
            if (!this.isBodyLoaded) {
                this.isBodyLoaded = true;
                this.lazyLoadedBody = this.loadBody();
            }
            return this.lazyLoadedBody;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadBody() {
            String string2;
            if (this.httpBodyInputStream == null) {
                return null;
            }
            BufferedSource buffer = null;
            try {
                buffer = Okio.buffer((Source)Okio.source((InputStream)this.httpBodyInputStream));
                string2 = buffer.readUtf8();
            }
            catch (IOException e) {
                String string3;
                try {
                    log.i("Error reading HTTP response body: ", e);
                    string3 = null;
                }
                catch (Throwable throwable) {
                    EZ.closeThisThingOrMaybeDont(buffer);
                    throw throwable;
                }
                EZ.closeThisThingOrMaybeDont((Closeable)buffer);
                return string3;
            }
            EZ.closeThisThingOrMaybeDont((Closeable)buffer);
            return string2;
        }
    }

    public static enum Kind {
        NETWORK,
        CONVERSION,
        HTTP,
        UNEXPECTED;

    }
}

