/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.persistance.SensitiveDataStorage;
import io.particle.android.sdk.utils.Py;

public class ParticleUser {
    @NonNull
    private final String user;
    @NonNull
    private final String password;

    public static synchronized ParticleUser fromNewCredentials(@NonNull String user, @NonNull String password) {
        Preconditions.checkArgument((boolean)Py.truthy(user), (Object)"Username cannot be empty or null");
        Preconditions.checkArgument((boolean)Py.truthy(password), (Object)"Password cannot be empty or null");
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.saveUser(user);
        sensitiveDataStorage.savePassword(password);
        return new ParticleUser(user, password);
    }

    public static synchronized ParticleUser fromSavedSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        String user = sensitiveDataStorage.getUser();
        String password = sensitiveDataStorage.getPassword();
        if (Py.truthy(user) && Py.truthy(password)) {
            return new ParticleUser(user, password);
        }
        return null;
    }

    public static void removeSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.resetPassword();
        sensitiveDataStorage.resetUser();
    }

    private ParticleUser(@NonNull String user, @NonNull String password) {
        this.user = user;
        this.password = password;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    @NonNull
    public String getUser() {
        return this.user;
    }
}

