/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.common.base.Preconditions;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.DeviceState;
import io.particle.android.sdk.cloud.FunctionArgs;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SDKProvider;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okio.Okio;
import okio.Source;
import org.apache.commons.lang3.StringUtils;
import retrofit.RetrofitError;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedOutput;

public class ParticleDevice
implements Parcelable {
    private static final int MAX_PARTICLE_FUNCTION_ARG_LENGTH = 63;
    private static final TLog log = TLog.get(ParticleDevice.class);
    @NonNull
    private final ApiDefs.CloudApi mainApi;
    @NonNull
    private final ParticleCloud cloud;
    @NonNull
    volatile DeviceState deviceState;
    private volatile boolean isFlashing = false;
    public static final Parcelable.Creator<ParticleDevice> CREATOR = new Parcelable.Creator<ParticleDevice>(){

        public ParticleDevice createFromParcel(Parcel in) {
            SDKProvider sdkProvider = ParticleCloudSDK.getSdkProvider();
            DeviceState deviceState = (DeviceState)in.readParcelable(DeviceState.class.getClassLoader());
            return sdkProvider.getParticleCloud().getDeviceFromState(deviceState);
        }

        public ParticleDevice[] newArray(int size) {
            return new ParticleDevice[size];
        }
    };

    ParticleDevice(@NonNull ApiDefs.CloudApi mainApi, @NonNull ParticleCloud cloud, @NonNull DeviceState deviceState) {
        this.mainApi = mainApi;
        this.cloud = cloud;
        this.deviceState = deviceState;
    }

    public String getID() {
        return this.deviceState.deviceId;
    }

    public String getName() {
        return this.deviceState.name;
    }

    public void setName(@NonNull String newName) throws ParticleCloudException {
        this.cloud.changeDeviceName(this.deviceState.deviceId, newName);
    }

    public boolean isConnected() {
        return this.deviceState.isConnected;
    }

    public Set<String> getFunctions() {
        return this.deviceState.functions;
    }

    public Map<String, String> getVariables() {
        return this.deviceState.variables;
    }

    public String getVersion() {
        return this.deviceState.version;
    }

    public boolean requiresUpdate() {
        return this.deviceState.requiresUpdate;
    }

    public ParticleDeviceType getDeviceType() {
        return this.deviceState.deviceType;
    }

    @WorkerThread
    public int getVariable(@NonNull String variableName) throws ParticleCloudException, IOException, VariableDoesNotExistException {
        Responses.ReadVariableResponse reply;
        if (!this.deviceState.variables.containsKey((Object)variableName)) {
            throw new VariableDoesNotExistException(variableName);
        }
        try {
            reply = this.mainApi.getVariable(this.deviceState.deviceId, variableName);
        }
        catch (RetrofitError e) {
            throw new ParticleCloudException(e);
        }
        if (!reply.coreInfo.connected) {
            this.cloud.onDeviceNotConnected(this.deviceState);
            throw new IOException("Device is not connected.");
        }
        return reply.result;
    }

    @WorkerThread
    public int callFunction(@NonNull String functionName, @Nullable List<String> args) throws ParticleCloudException, IOException, FunctionDoesNotExistException {
        Responses.CallFunctionResponse response;
        String argsString;
        if (!this.deviceState.functions.contains((Object)functionName)) {
            throw new FunctionDoesNotExistException(functionName);
        }
        if (args == null) {
            args = Py.list();
        }
        Preconditions.checkArgument(((argsString = StringUtils.join(args, (String)",")).length() < 63 ? 1 : 0) != 0, (Object)String.format("Arguments '%s' exceed max args length of %d", argsString, 63));
        try {
            response = this.mainApi.callFunction(this.deviceState.deviceId, functionName, new FunctionArgs(argsString));
        }
        catch (RetrofitError e) {
            throw new ParticleCloudException(e);
        }
        if (!response.connected) {
            this.cloud.onDeviceNotConnected(this.deviceState);
            throw new IOException("Device is not connected.");
        }
        return response.returnValue;
    }

    @WorkerThread
    public int callFunction(@NonNull String functionName) throws ParticleCloudException, IOException, FunctionDoesNotExistException {
        return this.callFunction(functionName, null);
    }

    private void addEventHandler(String eventName, Object eventHandler) {
    }

    private void removeEventHandler(String eventName) {
    }

    @WorkerThread
    public void unclaim() throws ParticleCloudException {
        try {
            this.cloud.unclaimDevice(this.deviceState.deviceId);
        }
        catch (RetrofitError e) {
            throw new ParticleCloudException(e);
        }
    }

    public boolean isRunningTinker() {
        List lowercaseFunctions = Py.list();
        for (String func : this.deviceState.functions) {
            lowercaseFunctions.add(func.toLowerCase());
        }
        List<String> tinkerFunctions = Py.list("analogread", "analogwrite", "digitalread", "digitalwrite");
        return this.isConnected() && lowercaseFunctions.containsAll(tinkerFunctions);
    }

    public boolean isFlashing() {
        return this.isFlashing;
    }

    @WorkerThread
    public void flashKnownApp(final @NonNull KnownApp knownApp) throws ParticleCloudException {
        this.performFlashingChange(new FlashingChange(){

            @Override
            public void executeFlashingChange() throws RetrofitError {
                ParticleDevice.this.mainApi.flashKnownApp(ParticleDevice.this.deviceState.deviceId, knownApp.appName);
            }
        });
    }

    @WorkerThread
    public void flashBinaryFile(final @NonNull File file) throws ParticleCloudException {
        this.performFlashingChange(new FlashingChange(){

            @Override
            public void executeFlashingChange() throws RetrofitError {
                ParticleDevice.this.mainApi.flashFile(ParticleDevice.this.deviceState.deviceId, (TypedOutput)new TypedFile("application/octet-stream", file));
            }
        });
    }

    @WorkerThread
    public void flashBinaryFile(InputStream stream) throws ParticleCloudException, IOException {
        final byte[] bytes = Okio.buffer((Source)Okio.source((InputStream)stream)).readByteArray();
        this.performFlashingChange(new FlashingChange(){

            @Override
            public void executeFlashingChange() throws RetrofitError {
                ParticleDevice.this.mainApi.flashFile(ParticleDevice.this.deviceState.deviceId, (TypedOutput)new TypedFakeFile(bytes));
            }
        });
    }

    @NonNull
    public ParticleCloud getCloud() {
        return this.cloud;
    }

    @WorkerThread
    public void refresh() throws ParticleCloudException {
        this.cloud.getDevice(this.deviceState.deviceId);
    }

    @WorkerThread
    private void resetFlashingState() {
        this.isFlashing = false;
        try {
            this.refresh();
        }
        catch (ParticleCloudException e) {
            this.cloud.notifyDeviceChanged();
            log.w("Unable to reset flashing state for %s" + this.deviceState.deviceId, e);
        }
    }

    private void performFlashingChange(FlashingChange flashingChange) throws ParticleCloudException {
        try {
            flashingChange.executeFlashingChange();
            this.isFlashing = true;
            this.cloud.notifyDeviceChanged();
            EZ.runOnMainThreadDelayed(30000L, new Runnable(){

                @Override
                public void run() {
                    EZ.runAsync(new Runnable(){

                        @Override
                        public void run() {
                            ParticleDevice.this.resetFlashingState();
                        }
                    });
                }
            });
        }
        catch (RetrofitError e) {
            throw new ParticleCloudException(e);
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.deviceState, flags);
    }

    public int describeContents() {
        return 0;
    }

    static class TypedFakeFile
    extends TypedByteArray {
        public TypedFakeFile(byte[] bytes) {
            super("application/octet-stream", bytes);
        }

        public String fileName() {
            return "tinker_firmware.bin";
        }
    }

    private static interface FlashingChange {
        public void executeFlashingChange() throws RetrofitError;
    }

    public static enum KnownApp {
        TINKER("tinker");

        private final String appName;

        private KnownApp(String appName) {
            this.appName = appName;
        }

        public String getAppName() {
            return this.appName;
        }
    }

    public class VariableDoesNotExistException
    extends Exception {
        public VariableDoesNotExistException(String variableName) {
            super("Variable " + variableName + " does not exist on this device");
        }
    }

    public class FunctionDoesNotExistException
    extends Exception {
        public FunctionDoesNotExistException(String functionName) {
            super("Function " + functionName + " does not exist on this device");
        }
    }

    public static enum ParticleDeviceType {
        CORE,
        PHOTON;


        public static ParticleDeviceType fromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return CORE;
                }
            }
            return PHOTON;
        }
    }
}

