/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.content.LocalBroadcastManager;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.DeviceState;
import io.particle.android.sdk.cloud.ParticleAccessToken;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.cloud.ParticleUser;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.persistance.AppDataStorage;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import retrofit.RetrofitError;

public class ParticleCloud {
    private static final TLog log = TLog.get(ParticleCloud.class);
    @NonNull
    private final ApiDefs.CloudApi mainApi;
    @NonNull
    private final ApiDefs.IdentityApi identityApi;
    @NonNull
    private final AppDataStorage appDataStorage;
    @NonNull
    private final TokenDelegate tokenDelegate = new TokenDelegate();
    @NonNull
    private final LocalBroadcastManager broadcastManager;
    private final Map<String, ParticleDevice> devices = new HashMap<String, ParticleDevice>();
    private volatile ParticleAccessToken token;
    private volatile ParticleUser user;
    private static final Function<ParticleDevice, String> toDeviceId = new Function<ParticleDevice, String>(){

        public String apply(ParticleDevice input) {
            return input.deviceState.deviceId;
        }
    };

    @Deprecated
    public static synchronized ParticleCloud get(@NonNull Context context) {
        log.w("ParticleCloud.get() is deprecated and will be removed before the 1.0 release. Use ParticleCloudSDK.getCloud() instead!");
        if (!ParticleCloudSDK.isInitialized()) {
            ParticleCloudSDK.init(context);
        }
        return ParticleCloudSDK.getCloud();
    }

    ParticleCloud(@NonNull ApiDefs.CloudApi mainApi, @NonNull ApiDefs.IdentityApi identityApi, @NonNull AppDataStorage appDataStorage, @NonNull LocalBroadcastManager broadcastManager) {
        this.mainApi = mainApi;
        this.identityApi = identityApi;
        this.appDataStorage = appDataStorage;
        this.broadcastManager = broadcastManager;
        this.user = ParticleUser.fromSavedSession();
        this.token = ParticleAccessToken.fromSavedSession();
        if (this.token != null) {
            this.token.setDelegate(new TokenDelegate());
        }
    }

    public String getAccessToken() {
        return this.token == null ? null : this.token.getAccessToken();
    }

    public String getLoggedInUsername() {
        return Py.all(this.token, this.user) ? this.user.getUser() : null;
    }

    public boolean isLoggedIn() {
        return this.getLoggedInUsername() != null;
    }

    @WorkerThread
    public void logIn(@NonNull String user, @NonNull String password) throws ParticleCloudException {
        try {
            Responses.LogInResponse response = this.identityApi.logIn("password", user, password);
            this.onLogIn(response, user, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void signUpWithUser(@NonNull String user, @NonNull String password) throws ParticleCloudException {
        try {
            this.identityApi.signUp(user, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void signUpAndLogInWithCustomer(@NonNull String email, @NonNull String password, @NonNull String orgSlug) throws ParticleCloudException {
        if (!Py.all(email, password, orgSlug)) {
            throw new IllegalArgumentException("Email, password, and organization must all be specified");
        }
        try {
            Responses.LogInResponse response = this.identityApi.signUpAndLogInWithCustomer("client_credentials", email, password, orgSlug);
            this.onLogIn(response, email, password);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    public void logOut() {
        if (this.token != null) {
            this.token.cancelExpiration();
        }
        ParticleUser.removeSession();
        ParticleAccessToken.removeSession();
        this.token = null;
        this.user = null;
    }

    @WorkerThread
    public List<ParticleDevice> getDevices() throws ParticleCloudException {
        try {
            List<Responses.Models.SimpleDevice> simpleDevices = this.mainApi.getDevices();
            this.appDataStorage.saveUserHasClaimedDevices(Py.truthy(simpleDevices));
            List<ParticleDevice> result = Py.list();
            for (Responses.Models.SimpleDevice simpleDevice : simpleDevices) {
                ParticleDevice device = this.getDevice(simpleDevice.id, false);
                result.add(device);
            }
            this.pruneDeviceMap(result);
            return result;
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public ParticleDevice getDevice(@NonNull String deviceID) throws ParticleCloudException {
        return this.getDevice(deviceID, true);
    }

    private void publishEvent(String eventName, byte[] eventData) throws ParticleCloudException {
    }

    @WorkerThread
    public void claimDevice(@NonNull String deviceID) throws ParticleCloudException {
        try {
            this.mainApi.claimDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCode() throws ParticleCloudException {
        try {
            return this.mainApi.generateClaimCode("okhttp_appeasement");
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public Responses.ClaimCodeResponse generateClaimCodeForOrg(@NonNull String orgSlug, @NonNull String productSlug) throws ParticleCloudException {
        try {
            return this.mainApi.generateClaimCodeForOrg("okhttp_appeasement", orgSlug, productSlug);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    @WorkerThread
    public void requestPasswordReset(@NonNull String email) throws ParticleCloudException {
        try {
            this.identityApi.requestPasswordReset(email);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void unclaimDevice(@NonNull String deviceId) {
        this.mainApi.unclaimDevice(deviceId);
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            this.devices.remove(deviceId);
        }
        this.sendUpdateBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void changeDeviceName(@NonNull String deviceId, @NonNull String newName) throws ParticleCloudException {
        ParticleDevice particleDevice;
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            particleDevice = this.devices.get(deviceId);
        }
        DeviceState originalDeviceState = particleDevice.deviceState;
        DeviceState stateWithNewName = DeviceState.withNewName(originalDeviceState, newName);
        this.updateDeviceState(stateWithNewName, true);
        try {
            this.mainApi.nameDevice(originalDeviceState.deviceId, newName);
        }
        catch (RetrofitError e) {
            this.updateDeviceState(originalDeviceState, true);
            throw new ParticleCloudException(e);
        }
    }

    @WorkerThread
    void onDeviceNotConnected(@NonNull DeviceState deviceState) {
        DeviceState newState = DeviceState.withNewConnectedState(deviceState, false);
        this.updateDeviceState(newState, true);
    }

    void notifyDeviceChanged() {
        this.sendUpdateBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParticleDevice getDeviceFromState(@NonNull DeviceState deviceState) {
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            if (this.devices.containsKey(deviceState.deviceId)) {
                return this.devices.get(deviceState.deviceId);
            }
            ParticleDevice device = new ParticleDevice(this.mainApi, this, deviceState);
            this.devices.put(deviceState.deviceId, device);
            return device;
        }
    }

    @WorkerThread
    private ParticleDevice getDevice(String deviceID, boolean sendUpdate) throws ParticleCloudException {
        Responses.Models.CompleteDevice deviceCloudModel;
        try {
            deviceCloudModel = this.mainApi.getDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new ParticleCloudException(error);
        }
        DeviceState newDeviceState = this.fromCompleteDevice(deviceCloudModel);
        ParticleDevice device = this.getDeviceFromState(newDeviceState);
        this.updateDeviceState(newDeviceState, sendUpdate);
        return device;
    }

    private void updateDeviceState(DeviceState newState, boolean sendUpdateBroadcast) {
        ParticleDevice device = this.getDeviceFromState(newState);
        device.deviceState = newState;
        if (sendUpdateBroadcast) {
            this.sendUpdateBroadcast();
        }
    }

    private void sendUpdateBroadcast() {
        this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
    }

    private void onLogIn(Responses.LogInResponse response, String user, String password) {
        this.token = ParticleAccessToken.fromNewSession(response);
        this.token.setDelegate(this.tokenDelegate);
        this.user = ParticleUser.fromNewCredentials(user, password);
    }

    private DeviceState fromCompleteDevice(Responses.Models.CompleteDevice completeDevice) {
        ImmutableSet functions = completeDevice.functions == null ? ImmutableSet.of() : ImmutableSet.copyOf(completeDevice.functions);
        ImmutableMap variables = completeDevice.variables == null ? ImmutableMap.of() : ImmutableMap.copyOf(completeDevice.variables);
        return new DeviceState(completeDevice.deviceId, completeDevice.name, completeDevice.isConnected, (ImmutableSet<String>)functions, (ImmutableMap<String, String>)variables, completeDevice.version, ParticleDevice.ParticleDeviceType.fromInt(completeDevice.productId), completeDevice.requiresUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeviceMap(List<ParticleDevice> latestCloudDeviceList) {
        Map<String, ParticleDevice> map = this.devices;
        synchronized (map) {
            HashSet currentDeviceIds = Sets.newHashSet(this.devices.keySet());
            ImmutableSet newDeviceIds = FluentIterable.from(latestCloudDeviceList).transform(toDeviceId).toSet();
            Sets.SetView toRemove = Sets.difference((Set)currentDeviceIds, (Set)newDeviceIds);
            for (String deviceId : toRemove) {
                this.devices.remove(deviceId);
            }
        }
    }

    private class TokenDelegate
    implements ParticleAccessToken.ParticleAccessTokenDelegate {
        private TokenDelegate() {
        }

        @Override
        public void accessTokenExpiredAt(ParticleAccessToken accessToken, Date expirationDate) {
            if (ParticleCloud.this.user != null) {
                try {
                    ParticleCloud.this.logIn(ParticleCloud.this.user.getUser(), ParticleCloud.this.user.getPassword());
                }
                catch (ParticleCloudException e) {
                    log.e("Error while trying to log in: ", e);
                    ParticleCloud.this.token = null;
                }
            } else {
                ParticleCloud.this.token = null;
            }
        }
    }
}

