/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.persistance;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.Date;

@SuppressLint(value={"CommitPrefEdits"})
public class SensitiveDataStorage {
    private static final String KEY_USERNAME = "KEY_USERNAME";
    private static final String KEY_PASSWORD = "KEY_PASSWORD";
    private static final String KEY_TOKEN = "KEY_TOKEN";
    private static final String KEY_TOKEN_EXPIRATION_DATE = "KEY_TOKEN_EXPIRATION_DATE";
    private final SharedPreferences sharedPrefs;

    public SensitiveDataStorage(Context ctx) {
        ctx = ctx.getApplicationContext();
        this.sharedPrefs = ctx.getSharedPreferences("spark_sdk_sensitive_data", 0);
    }

    public void saveUser(String user) {
        this.sharedPrefs.edit().putString(KEY_USERNAME, user).commit();
    }

    public String getUser() {
        return this.sharedPrefs.getString(KEY_USERNAME, null);
    }

    public void resetUser() {
        this.sharedPrefs.edit().remove(KEY_USERNAME).commit();
    }

    public void savePassword(String password) {
        this.sharedPrefs.edit().putString(KEY_PASSWORD, password).commit();
    }

    public String getPassword() {
        return this.sharedPrefs.getString(KEY_PASSWORD, null);
    }

    public void resetPassword() {
        this.sharedPrefs.edit().remove(KEY_PASSWORD).commit();
    }

    public void saveToken(String token) {
        this.sharedPrefs.edit().putString(KEY_TOKEN, token).commit();
    }

    public String getToken() {
        return this.sharedPrefs.getString(KEY_TOKEN, null);
    }

    public void resetToken() {
        this.sharedPrefs.edit().remove(KEY_TOKEN).commit();
    }

    public void saveTokenExpirationDate(Date expirationDate) {
        this.sharedPrefs.edit().putLong(KEY_TOKEN_EXPIRATION_DATE, expirationDate.getTime()).commit();
    }

    public Date getTokenExpirationDate() {
        long expirationTs = this.sharedPrefs.getLong(KEY_TOKEN_EXPIRATION_DATE, -1L);
        return expirationTs == -1L ? null : new Date(expirationTs);
    }

    public void resetTokenExpirationDate() {
        this.sharedPrefs.edit().remove(KEY_TOKEN_EXPIRATION_DATE).commit();
    }
}

