/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import com.google.common.base.Preconditions;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.persistance.SensitiveDataStorage;
import io.particle.android.sdk.utils.Py;

public class SparkUser {
    private final String user;
    private final String password;

    public static synchronized SparkUser fromNewCredentials(String user, String password) {
        Preconditions.checkArgument((boolean)Py.truthy(user), (Object)"Username cannot be empty or null");
        Preconditions.checkArgument((boolean)Py.truthy(password), (Object)"Password cannot be empty or null");
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.saveUser(user);
        sensitiveDataStorage.savePassword(password);
        return new SparkUser(user, password);
    }

    public static synchronized SparkUser fromSavedSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        String user = sensitiveDataStorage.getUser();
        String password = sensitiveDataStorage.getPassword();
        if (Py.truthy(user) && Py.truthy(password)) {
            return new SparkUser(user, password);
        }
        return null;
    }

    public static void removeSession() {
        SensitiveDataStorage sensitiveDataStorage = SDKGlobals.getSensitiveDataStorage();
        sensitiveDataStorage.resetPassword();
        sensitiveDataStorage.resetUser();
    }

    private SparkUser(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }
}

