/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.util.ArrayMap;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.FunctionArgs;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okio.Okio;
import okio.Source;
import org.apache.commons.lang3.StringUtils;
import retrofit.RetrofitError;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedOutput;

public class SparkDevice {
    private static final int MAX_SPARK_FUNCTION_ARG_LENGTH = 63;
    private final ApiDefs.CloudApi mainApi;
    private final LocalBroadcastManager broadcastManager;
    private final SparkCloud cloud;
    private volatile String deviceId;
    private volatile String name;
    private volatile boolean isConnected;
    private volatile boolean isFlashing;
    private volatile List<String> functions = Py.list();
    private volatile Map<String, Object> variables = Py.map();
    private volatile String version;
    private volatile SparkDeviceType deviceType;
    private volatile boolean requiresUpdate;

    public static Builder newBuilder() {
        return new Builder();
    }

    private SparkDevice(ApiDefs.CloudApi mainApi, LocalBroadcastManager broadcastManager, SparkCloud cloud, String deviceId, String name, boolean isConnected, List<String> functions, Map<String, Object> variables, String version, SparkDeviceType deviceType, boolean requiresUpdate, boolean isFlashing) {
        this.mainApi = mainApi;
        this.broadcastManager = broadcastManager;
        this.cloud = cloud;
        this.deviceId = deviceId;
        this.name = name;
        this.isConnected = isConnected;
        this.functions = functions;
        this.variables = variables;
        this.version = version;
        this.deviceType = deviceType;
        this.requiresUpdate = requiresUpdate;
        this.isFlashing = isFlashing;
    }

    public String getID() {
        return this.deviceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) throws SparkCloudException {
        String oldName = this.name;
        this.name = newName;
        this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
        try {
            this.mainApi.nameDevice(this.deviceId, newName);
            this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
        }
        catch (RetrofitError e) {
            this.name = oldName;
            this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
            throw new SparkCloudException(e);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public Set<String> getFunctions() {
        return Py.set(this.functions);
    }

    public Map<String, Object> getVariables() {
        ArrayMap copy = new ArrayMap();
        copy.putAll(this.variables);
        return copy;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean requiresUpdate() {
        return this.requiresUpdate;
    }

    public SparkDeviceType getDeviceType() {
        return this.deviceType;
    }

    public int getVariable(String variableName) throws SparkCloudException, IOException, VariableDoesNotExistException {
        Responses.ReadVariableResponse reply;
        if (!this.variables.containsKey(variableName)) {
            throw new VariableDoesNotExistException(variableName);
        }
        try {
            reply = this.mainApi.getVariable(this.deviceId, variableName);
        }
        catch (RetrofitError e) {
            throw new SparkCloudException(e);
        }
        this.isConnected = reply.coreInfo.connected;
        if (!reply.coreInfo.connected) {
            throw new IOException("Device is not connected.");
        }
        return reply.result;
    }

    public int callFunction(String functionName, List<String> args) throws SparkCloudException, IOException, FunctionDoesNotExistException {
        Responses.CallFunctionResponse response;
        String argsString;
        if (!this.functions.contains(functionName)) {
            throw new FunctionDoesNotExistException(functionName);
        }
        if (args == null) {
            args = Py.list();
        }
        Preconditions.checkArgument(((argsString = StringUtils.join(args, (String)",")).length() < 63 ? 1 : 0) != 0, (Object)String.format("Arguments '%s' exceed max args length of %d", argsString, 63));
        try {
            response = this.mainApi.callFunction(this.deviceId, functionName, new FunctionArgs(argsString));
        }
        catch (RetrofitError e) {
            throw new SparkCloudException(e);
        }
        this.isConnected = response.connected;
        if (!response.connected) {
            throw new IOException("Device is not connected.");
        }
        return response.returnValue;
    }

    public int callFunction(String functionName) throws SparkCloudException, IOException, FunctionDoesNotExistException {
        return this.callFunction(functionName, new ArrayList<String>());
    }

    public void addEventHandler(String eventName, Object eventHandler) {
    }

    public void removeEventHandler(String eventName) {
    }

    public void unclaim() throws SparkCloudException {
        try {
            this.mainApi.unclaimDevice(this.deviceId);
            this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
        }
        catch (RetrofitError e) {
            throw new SparkCloudException(e);
        }
    }

    public boolean isRunningTinker() {
        List lowercaseFunctions = Py.list();
        for (String func : this.functions) {
            lowercaseFunctions.add(func.toLowerCase());
        }
        List<String> tinkerFunctions = Py.list("analogread", "analogwrite", "digitalread", "digitalwrite");
        return this.isConnected() && lowercaseFunctions.containsAll(tinkerFunctions);
    }

    public boolean isFlashing() {
        return this.isFlashing;
    }

    public void flashKnownApp(final KnownApp knownApp) throws SparkCloudException {
        this.performFlashingChange(new FlashingChange(){

            @Override
            public void executeFlashingChange() throws RetrofitError {
                SparkDevice.this.mainApi.flashKnownApp(SparkDevice.this.deviceId, knownApp.appName);
            }
        });
    }

    public void flashBinaryFile(final File file) throws SparkCloudException {
        this.performFlashingChange(new FlashingChange(){

            @Override
            public void executeFlashingChange() throws RetrofitError {
                SparkDevice.this.mainApi.flashFile(SparkDevice.this.deviceId, (TypedOutput)new TypedFile("application/octet-stream", file));
            }
        });
    }

    public void flashBinaryFile(InputStream stream) throws SparkCloudException, IOException {
        final byte[] bytes = Okio.buffer((Source)Okio.source((InputStream)stream)).readByteArray();
        this.performFlashingChange(new FlashingChange(){

            @Override
            public void executeFlashingChange() throws RetrofitError {
                SparkDevice.this.mainApi.flashFile(SparkDevice.this.deviceId, (TypedOutput)new TypedFakeFile(bytes));
            }
        });
    }

    private void resetFlashingState() {
        this.isFlashing = false;
        try {
            SparkDevice currentDevice = this.cloud.getDevice(this.deviceId);
            currentDevice.isFlashing = false;
        }
        catch (SparkCloudException e) {
            e.printStackTrace();
        }
        this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
    }

    public SparkCloud getCloud() {
        return this.cloud;
    }

    private void performFlashingChange(FlashingChange flashingChange) throws SparkCloudException {
        try {
            flashingChange.executeFlashingChange();
            this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
            this.isFlashing = true;
            EZ.runOnMainThreadDelayed(30000L, new Runnable(){

                @Override
                public void run() {
                    SparkDevice.this.resetFlashingState();
                }
            });
        }
        catch (RetrofitError e) {
            this.resetFlashingState();
            throw new SparkCloudException(e);
        }
        finally {
            this.broadcastManager.sendBroadcast(new Intent("BROADCAST_DEVICES_UPDATED"));
        }
    }

    static class TypedFakeFile
    extends TypedByteArray {
        public TypedFakeFile(byte[] bytes) {
            super("application/octet-stream", bytes);
        }

        public String fileName() {
            return "tinker_firmware.bin";
        }
    }

    public static class Builder {
        private transient ApiDefs.CloudApi mainApi;
        private transient LocalBroadcastManager broadcastManager;
        private transient SparkCloud cloud;
        @SerializedName(value="id")
        private String deviceId;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="connected")
        private boolean isConnected;
        @SerializedName(value="variables")
        private Map<String, Object> variables;
        @SerializedName(value="functions")
        private List<String> functions;
        @SerializedName(value="cc3000_patch_version")
        private String version;
        @SerializedName(value="product_id")
        private int productId;
        @SerializedName(value="device_needs_update")
        private boolean requiresUpdate;
        private transient SparkDeviceType deviceType;
        private transient boolean isFlashing;

        private void validate() {
            if (!Py.all(new Object[]{this.mainApi, this.broadcastManager, this.cloud, this.deviceId, this.deviceType})) {
                throw new IllegalStateException(String.format("One or more required arguments were not set on builder. mainApi=%s, broadcastManager=%s, cloud=%s, deviceId=%s, deviceType=%s", new Object[]{this.mainApi, this.broadcastManager, this.cloud, this.deviceId, this.deviceType}));
            }
        }

        SparkDevice build() {
            if (this.deviceType == null) {
                this.deviceType = this.productId == 0 ? SparkDeviceType.CORE : SparkDeviceType.PHOTON;
            }
            this.validate();
            if (this.variables == null) {
                this.variables = Py.map();
            }
            if (this.functions == null) {
                this.functions = Py.list();
            }
            return new SparkDevice(this.mainApi, this.broadcastManager, this.cloud, this.deviceId, this.name, this.isConnected, this.functions, this.variables, this.version, this.deviceType, this.requiresUpdate, this.isFlashing);
        }

        Builder setBroadcastManager(LocalBroadcastManager broadcastManager) {
            this.broadcastManager = broadcastManager;
            return this;
        }

        Builder setMainApi(ApiDefs.CloudApi mainApi) {
            this.mainApi = mainApi;
            return this;
        }

        Builder setSparkCloud(SparkCloud cloud) {
            this.cloud = cloud;
            return this;
        }

        Builder setProductId(int productId) {
            this.productId = productId;
            return this;
        }

        Builder setDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        Builder setName(String name) {
            this.name = name;
            return this;
        }

        Builder setIsConnected(boolean isConnected) {
            this.isConnected = isConnected;
            return this;
        }

        Builder setFunctions(List<String> functions) {
            this.functions = functions;
            return this;
        }

        Builder setVariables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        Builder setDeviceType(SparkDeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        Builder setRequiresUpdate(boolean requiresUpdate) {
            this.requiresUpdate = requiresUpdate;
            return this;
        }

        Builder setIsFlashing(boolean flashing) {
            this.isFlashing = flashing;
            return this;
        }

        ApiDefs.CloudApi getMainApi() {
            return this.mainApi;
        }

        SparkCloud getCloud() {
            return this.cloud;
        }

        LocalBroadcastManager getBroadcastManager() {
            return this.broadcastManager;
        }

        String getDeviceId() {
            return this.deviceId;
        }

        String getName() {
            return this.name;
        }

        boolean isConnected() {
            return this.isConnected;
        }

        List<String> getFunctions() {
            return this.functions;
        }

        Map<String, Object> getVariables() {
            return this.variables;
        }

        String getVersion() {
            return this.version;
        }

        SparkDeviceType getDeviceType() {
            return this.deviceType;
        }

        boolean requiresUpdate() {
            return this.requiresUpdate;
        }
    }

    private static interface FlashingChange {
        public void executeFlashingChange() throws RetrofitError;
    }

    public static enum KnownApp {
        TINKER("tinker");

        private final String appName;

        private KnownApp(String appName) {
            this.appName = appName;
        }

        public String getAppName() {
            return this.appName;
        }
    }

    public class VariableDoesNotExistException
    extends Exception {
        public VariableDoesNotExistException(String variableName) {
            super("Variable " + variableName + " does not exist on this device");
        }
    }

    public class FunctionDoesNotExistException
    extends Exception {
        public FunctionDoesNotExistException(String functionName) {
            super("Function " + functionName + " does not exist on this device");
        }
    }

    public static enum SparkDeviceType {
        CORE,
        PHOTON;


        public static SparkDeviceType fromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return CORE;
                }
            }
            return PHOTON;
        }
    }
}

