/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.support.v4.content.LocalBroadcastManager;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.ApiFactory;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.cloud.SparkAccessToken;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.cloud.SparkDevice;
import io.particle.android.sdk.cloud.SparkUser;
import io.particle.android.sdk.persistance.AppDataStorage;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import retrofit.RetrofitError;

public class SparkCloud {
    private static final TLog log = TLog.get(SparkCloud.class);
    private static SparkCloud instance;
    private final ApiDefs.CloudApi mainApi;
    private final ApiDefs.IdentityApi identityApi;
    private final AppDataStorage appDataStorage;
    private final TokenDelegate tokenDelegate = new TokenDelegate();
    private final LocalBroadcastManager broadcastManager;
    private volatile SparkAccessToken token;
    private volatile SparkUser user;
    private volatile Map<String, SparkDevice> deviceCache = Py.map();

    public static synchronized SparkCloud get(Context context) {
        if (instance == null) {
            log.d("Initializing SparkCloud instance");
            instance = SparkCloud.buildInstance(context);
        }
        return instance;
    }

    private static SparkCloud buildInstance(Context context) {
        SparkCloud cloud;
        Context appContext = context.getApplicationContext();
        SDKGlobals.init(appContext);
        TokenGetter tokenGetter = new TokenGetter();
        ApiFactory factory = new ApiFactory(appContext, tokenGetter);
        tokenGetter.cloud = cloud = new SparkCloud(factory.buildCloudApi(), factory.buildIdentityApi(), SDKGlobals.getAppDataStorage(), LocalBroadcastManager.getInstance((Context)context));
        return cloud;
    }

    private SparkCloud(ApiDefs.CloudApi mainApi, ApiDefs.IdentityApi identityApi, AppDataStorage appDataStorage, LocalBroadcastManager broadcastManager) {
        this.mainApi = mainApi;
        this.identityApi = identityApi;
        this.appDataStorage = appDataStorage;
        this.broadcastManager = broadcastManager;
        this.user = SparkUser.fromSavedSession();
        this.token = SparkAccessToken.fromSavedSession();
        if (this.token != null) {
            this.token.setDelegate(new TokenDelegate());
        }
    }

    public String getAccessToken() {
        return this.token == null ? null : this.token.getAccessToken();
    }

    public String getLoggedInUsername() {
        return Py.all(this.token, this.user) ? this.user.getUser() : null;
    }

    public void logIn(String user, String password) throws SparkCloudException {
        try {
            Responses.LogInResponse response = this.identityApi.logIn("password", user, password);
            this.token = SparkAccessToken.fromNewSession(response);
            this.token.setDelegate(this.tokenDelegate);
            this.user = SparkUser.fromNewCredentials(user, password);
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public void signUpWithUser(String user, String password) throws SparkCloudException {
        try {
            this.identityApi.signUp(user, password);
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public void signUpWithOrganization(String email, String password, String inviteCode, String orgName) throws SparkCloudException {
        if (!Py.truthy(orgName)) {
            throw new IllegalArgumentException("Organization name not specified");
        }
        try {
            this.identityApi.signUpWithOrganizationalUser(email, password, inviteCode, orgName);
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public void logOut() {
        if (this.token != null) {
            this.token.cancelExpiration();
        }
        SparkUser.removeSession();
        SparkAccessToken.removeSession();
        this.token = null;
        this.user = null;
    }

    public List<SparkDevice> getDevices() throws SparkCloudException {
        try {
            List<Responses.Models.SimpleDevice> simpleDevices = this.mainApi.getDevices();
            this.appDataStorage.saveUserHasClaimedDevices(Py.truthy(simpleDevices));
            List<SparkDevice> devices = Py.list();
            for (Responses.Models.SimpleDevice simpleDevice : simpleDevices) {
                SparkDevice.Builder builder = simpleDevice.isConnected ? this.mainApi.getDevice(simpleDevice.id) : SparkDevice.newBuilder().setDeviceId(simpleDevice.id).setIsConnected(simpleDevice.isConnected).setName(simpleDevice.name);
                SparkDevice oldDevice = this.deviceCache.get(simpleDevice.id);
                if (oldDevice != null) {
                    builder.setIsFlashing(oldDevice.isFlashing());
                }
                devices.add(builder.setMainApi(this.mainApi).setDeviceType(SparkDevice.SparkDeviceType.fromInt(simpleDevice.productId)).setBroadcastManager(this.broadcastManager).setSparkCloud(this).build());
            }
            Map<String, SparkDevice> deviceMap = Py.map();
            for (SparkDevice d : devices) {
                deviceMap.put(d.getID(), d);
            }
            this.deviceCache = deviceMap;
            return devices;
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public SparkDevice getDevice(String deviceID) throws SparkCloudException {
        SparkDevice.Builder deviceBuilder;
        if (this.deviceCache.containsKey(deviceID)) {
            return this.deviceCache.get(deviceID);
        }
        try {
            deviceBuilder = this.mainApi.getDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
        return deviceBuilder.setMainApi(this.mainApi).setBroadcastManager(this.broadcastManager).setSparkCloud(this).build();
    }

    private void publishEvent(String eventName, byte[] eventData) throws SparkCloudException {
    }

    public void claimDevice(String deviceID) throws SparkCloudException {
        try {
            this.mainApi.claimDevice(deviceID);
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public Responses.ClaimCodeResponse generateClaimCode() throws SparkCloudException {
        try {
            return this.mainApi.generateClaimCode("");
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public void requestPasswordReset(String email) throws SparkCloudException {
        try {
            this.identityApi.requestPasswordReset(email);
        }
        catch (RetrofitError error) {
            throw new SparkCloudException(error);
        }
    }

    public Set<String> getDeviceNames() {
        Py.PySet<String> deviceNames = Py.set(new String[0]);
        for (SparkDevice device : this.deviceCache.values()) {
            deviceNames.add(device.getName());
        }
        return deviceNames;
    }

    private class TokenDelegate
    implements SparkAccessToken.SparkAccessTokenDelegate {
        private TokenDelegate() {
        }

        @Override
        public void accessTokenExpiredAt(SparkAccessToken accessToken, Date expirationDate) {
            if (SparkCloud.this.user != null) {
                try {
                    SparkCloud.this.logIn(SparkCloud.this.user.getUser(), SparkCloud.this.user.getPassword());
                }
                catch (SparkCloudException e) {
                    log.e("Error while trying to log in: ", e);
                    SparkCloud.this.token = null;
                }
            } else {
                SparkCloud.this.token = null;
            }
        }
    }

    private static class TokenGetter
    implements ApiFactory.TokenGetterDelegate {
        volatile SparkCloud cloud;

        private TokenGetter() {
        }

        @Override
        public String getTokenValue() {
            return this.cloud.getAccessToken();
        }
    }
}

