/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.app.Activity;
import android.os.AsyncTask;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.cloud.SparkDevice;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;

public class Async {
    private static final TLog log = TLog.get(Async.class);

    public static <T> AsyncApiWorker<SparkCloud, T> executeAsync(SparkCloud sparkCloud, ApiWork<SparkCloud, T> work) {
        return (AsyncApiWorker)new AsyncApiWorker(sparkCloud, work).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static <T> AsyncApiWorker<SparkDevice, T> executeAsync(SparkDevice sparkDevice, ApiWork<SparkDevice, T> work) {
        return (AsyncApiWorker)new AsyncApiWorker(sparkDevice, work).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static class AsyncApiWorker<ApiCaller, Result>
    extends AsyncTask<Void, Void, Result> {
        private final ApiCaller caller;
        private final ApiWork<ApiCaller, Result> work;
        private Activity activity;
        private volatile SparkCloudException exception;
        public volatile IOException ioException;

        private AsyncApiWorker(ApiCaller caller, ApiWork<ApiCaller, Result> work) {
            this.caller = caller;
            this.work = work;
        }

        public AsyncApiWorker<ApiCaller, Result> andIgnoreCallbacksIfActivityIsFinishing(Activity activity) {
            this.activity = activity;
            return this;
        }

        protected Result doInBackground(Void ... voids) {
            try {
                return this.work.callApi(this.caller);
            }
            catch (SparkCloudException e) {
                this.exception = e;
                return null;
            }
            catch (IOException e) {
                this.ioException = e;
                return null;
            }
        }

        protected void onCancelled() {
            if (this.shouldCallCallbacks()) {
                this.work.onTaskFinished();
                this.work.onCancelled();
            }
        }

        protected void onPostExecute(Result result) {
            if (!this.shouldCallCallbacks()) {
                return;
            }
            this.work.onTaskFinished();
            if (this.exception == null && this.ioException == null) {
                this.work.onSuccess(result);
            } else {
                log.e("Error calling API: " + this.exception.getBestMessage(), this.exception);
                this.work.onFailure(this.exception);
            }
        }

        private boolean shouldCallCallbacks() {
            boolean shouldCall;
            if (this.activity == null) {
                return true;
            }
            boolean bl = shouldCall = !this.activity.isFinishing();
            if (!shouldCall) {
                log.d("Refusing to call callbacks, was told to ignore them if the activity was finishing");
            }
            return shouldCall;
        }
    }

    public static abstract class ApiProcedure<ApiCaller>
    extends ApiWork<ApiCaller, Void> {
        @Override
        public void onSuccess(Void voyd) {
        }
    }

    public static abstract class ApiWork<ApiCaller, Result> {
        public abstract Result callApi(ApiCaller var1) throws SparkCloudException, IOException;

        public abstract void onSuccess(Result var1);

        public abstract void onFailure(SparkCloudException var1);

        public void onTaskFinished() {
        }

        public void onCancelled() {
        }
    }
}

