/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import com.squareup.okhttp.OkHttpClient;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.R;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;

public class ApiFactory {
    private final Context ctx;
    private final TokenGetterDelegate tokenDelegate;
    private final OkHttpClient okHttpClient;

    public ApiFactory(Context ctx, TokenGetterDelegate tokenGetterDelegate) {
        this.ctx = ctx.getApplicationContext();
        this.tokenDelegate = tokenGetterDelegate;
        this.okHttpClient = new OkHttpClient();
    }

    public ApiDefs.CloudApi buildCloudApi() {
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder().setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", "Bearer " + ApiFactory.this.tokenDelegate.getTokenValue());
            }
        }).build();
        return (ApiDefs.CloudApi)restAdapter.create(ApiDefs.CloudApi.class);
    }

    public ApiDefs.IdentityApi buildIdentityApi() {
        final String basicAuthValue = this.getBasicAuthValue();
        RestAdapter restAdapter = this.buildCommonRestAdapterBuilder().setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", basicAuthValue);
            }
        }).build();
        return (ApiDefs.IdentityApi)restAdapter.create(ApiDefs.IdentityApi.class);
    }

    public Uri getApiUri() {
        return Uri.parse((String)this.ctx.getString(R.string.api_base_uri));
    }

    private String getBasicAuthValue() {
        String clientId = this.ctx.getString(R.string.oauth_client_id);
        String clientSecret = this.ctx.getString(R.string.oauth_client_secret);
        return "Basic " + Base64.encodeToString((byte[])String.format("%s:%s", clientId, clientSecret).getBytes(), (int)2);
    }

    private RestAdapter.Builder buildCommonRestAdapterBuilder() {
        return new RestAdapter.Builder().setClient((Client)new OkClient(this.okHttpClient)).setEndpoint(this.getApiUri().toString()).setLogLevel(RestAdapter.LogLevel.valueOf((String)this.ctx.getString(R.string.http_log_level)));
    }

    public static interface TokenGetterDelegate {
        public String getTokenValue();
    }
}

