/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.orangebeard.client.entity.DateSerializer;
import io.orangebeard.client.entity.LogLevel;
import java.time.LocalDateTime;
import java.util.UUID;

public class Log {
    private UUID itemUuid;
    @JsonProperty(value="launchUuid")
    private UUID testRunUUID;
    @JsonSerialize(using=DateSerializer.class)
    private LocalDateTime time;
    private String message;
    @JsonProperty(value="level")
    private LogLevel logLevel;

    public Log(UUID testRunUUID, UUID testItemUUID, LogLevel logLevel, String message) {
        this.itemUuid = testItemUUID;
        this.testRunUUID = testRunUUID;
        this.logLevel = logLevel;
        this.time = LocalDateTime.now();
        this.message = message;
    }

    public static LogBuilder builder() {
        return new LogBuilder();
    }

    public UUID getItemUuid() {
        return this.itemUuid;
    }

    public UUID getTestRunUUID() {
        return this.testRunUUID;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String getMessage() {
        return this.message;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Log)) {
            return false;
        }
        Log other = (Log)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$itemUuid = this.getItemUuid();
        UUID other$itemUuid = other.getItemUuid();
        if (this$itemUuid == null ? other$itemUuid != null : !((Object)this$itemUuid).equals(other$itemUuid)) {
            return false;
        }
        UUID this$testRunUUID = this.getTestRunUUID();
        UUID other$testRunUUID = other.getTestRunUUID();
        if (this$testRunUUID == null ? other$testRunUUID != null : !((Object)this$testRunUUID).equals(other$testRunUUID)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        LogLevel this$logLevel = this.getLogLevel();
        LogLevel other$logLevel = other.getLogLevel();
        return !(this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Log;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $itemUuid = this.getItemUuid();
        result = result * 59 + ($itemUuid == null ? 43 : ((Object)$itemUuid).hashCode());
        UUID $testRunUUID = this.getTestRunUUID();
        result = result * 59 + ($testRunUUID == null ? 43 : ((Object)$testRunUUID).hashCode());
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        LogLevel $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        return result;
    }

    public Log() {
    }

    public Log(UUID itemUuid, UUID testRunUUID, LocalDateTime time, String message, LogLevel logLevel) {
        this.itemUuid = itemUuid;
        this.testRunUUID = testRunUUID;
        this.time = time;
        this.message = message;
        this.logLevel = logLevel;
    }

    public static class LogBuilder {
        private UUID itemUuid;
        private UUID testRunUUID;
        private LocalDateTime time;
        private String message;
        private LogLevel logLevel;

        LogBuilder() {
        }

        public LogBuilder itemUuid(UUID itemUuid) {
            this.itemUuid = itemUuid;
            return this;
        }

        @JsonProperty(value="launchUuid")
        public LogBuilder testRunUUID(UUID testRunUUID) {
            this.testRunUUID = testRunUUID;
            return this;
        }

        public LogBuilder time(LocalDateTime time) {
            this.time = time;
            return this;
        }

        public LogBuilder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="level")
        public LogBuilder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Log build() {
            return new Log(this.itemUuid, this.testRunUUID, this.time, this.message, this.logLevel);
        }

        public String toString() {
            return "Log.LogBuilder(itemUuid=" + this.itemUuid + ", testRunUUID=" + this.testRunUUID + ", time=" + this.time + ", message=" + this.message + ", logLevel=" + (Object)((Object)this.logLevel) + ")";
        }
    }
}

