/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client;

import io.orangebeard.client.AbstractClient;
import io.orangebeard.client.entity.Attachment;
import io.orangebeard.client.entity.FinishTestItem;
import io.orangebeard.client.entity.FinishTestRun;
import io.orangebeard.client.entity.Log;
import io.orangebeard.client.entity.Response;
import io.orangebeard.client.entity.StartTestItem;
import io.orangebeard.client.entity.StartTestRun;
import io.orangebeard.client.entity.UpdateTestRun;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class OrangebeardV2Client
extends AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrangebeardV2Client.class);
    private final String endpoint;
    private final RestTemplate restTemplate;
    private final String projectName;
    private boolean connectionWithOrangebeardIsValid;

    public OrangebeardV2Client(String endpoint, UUID uuid, String projectName, boolean connectionWithOrangebeardIsValid) {
        super(uuid);
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(30000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        this.endpoint = endpoint;
        this.projectName = projectName == null ? null : projectName.toLowerCase();
        this.connectionWithOrangebeardIsValid = connectionWithOrangebeardIsValid;
    }

    public OrangebeardV2Client(RestTemplate restTemplate, String endpoint, UUID uuid, String projectName, boolean connectionWithOrangebeardIsValid) {
        super(uuid);
        this.restTemplate = restTemplate;
        this.endpoint = endpoint;
        this.projectName = projectName == null ? null : projectName.toLowerCase();
        this.connectionWithOrangebeardIsValid = connectionWithOrangebeardIsValid;
    }

    @Override
    public UUID startTestRun(StartTestRun testRun) {
        if (this.connectionWithOrangebeardIsValid) {
            try {
                HttpEntity request = new HttpEntity((Object)testRun, (MultiValueMap)this.getAuthorizationHeaders(this.uuid.toString()));
                return ((Response)this.restTemplate.exchange(String.format("%s/listener/v2/%s/launch", this.endpoint, this.projectName), HttpMethod.POST, request, Response.class, new Object[0]).getBody()).getId();
            }
            catch (Exception e) {
                LOGGER.error("The connection with Orangebeard could not be established! Check the properties and try again!");
                this.connectionWithOrangebeardIsValid = false;
            }
        }
        return null;
    }

    @Override
    public void updateTestRun(UUID testRunUUID, UpdateTestRun updateTestRun) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)updateTestRun, (MultiValueMap)this.getAuthorizationHeaders(this.uuid.toString()));
            this.restTemplate.exchange(String.format("%s/listener/v2/%s/launch/%s/update", this.endpoint, this.projectName, testRunUUID), HttpMethod.PUT, request, Response.class, new Object[0]);
        } else {
            LOGGER.warn("The connection with Orangebeard could not be established!");
        }
    }

    @Override
    public UUID startTestItem(UUID suiteId, StartTestItem testItem) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)testItem, (MultiValueMap)this.getAuthorizationHeaders(this.uuid.toString()));
            if (suiteId == null) {
                return ((Response)this.restTemplate.exchange(String.format("%s/listener/v2/%s/item", this.endpoint, this.projectName), HttpMethod.POST, request, Response.class, new Object[0]).getBody()).getId();
            }
            return ((Response)this.restTemplate.exchange(String.format("%s/listener/v2/%s/item/%s", this.endpoint, this.projectName, suiteId), HttpMethod.POST, request, Response.class, new Object[0]).getBody()).getId();
        }
        LOGGER.warn("The connection with Orangebeard could not be established!");
        return null;
    }

    @Override
    public void finishTestItem(UUID itemId, FinishTestItem finishTestItem) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)finishTestItem, (MultiValueMap)this.getAuthorizationHeaders(this.uuid.toString()));
            this.restTemplate.exchange(String.format("%s/listener/v2/%s/item/%s", this.endpoint, this.projectName, itemId), HttpMethod.PUT, request, Response.class, new Object[0]);
        } else {
            LOGGER.warn("The connection with Orangebeard could not be established!");
        }
    }

    @Override
    public void finishTestRun(UUID testRunUUID, FinishTestRun finishTestRun) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)finishTestRun, (MultiValueMap)this.getAuthorizationHeaders(this.uuid.toString()));
            this.restTemplate.exchange(String.format("%s/listener/v2/%s/launch/%s/finish", this.endpoint, this.projectName, testRunUUID), HttpMethod.PUT, request, Response.class, new Object[0]);
        } else {
            LOGGER.warn("The connection with Orangebeard could not be established!");
        }
    }

    @Override
    public void log(Log log) {
        if (this.connectionWithOrangebeardIsValid) {
            try {
                HttpEntity request = new HttpEntity((Object)log, (MultiValueMap)this.getAuthorizationHeaders(this.uuid.toString()));
                this.restTemplate.exchange(String.format("%s/listener/v2/%s/log", this.endpoint, this.projectName), HttpMethod.POST, request, Response.class, new Object[0]);
            }
            catch (HttpServerErrorException | ResourceAccessException e) {
                LOGGER.error("Log cannot be reported to Orangebeard. Uuid=[{}]; loglevel=[{}]; message=[{}]", new Object[]{log.getItemUuid(), log.getLogLevel(), log.getMessage(), e});
            }
        } else {
            LOGGER.warn("The connection with Orangebeard could not be established!");
        }
    }

    @Override
    public void sendAttachment(Attachment attachment) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity<LinkedMultiValueMap<String, Object>> request = this.getMultipartLogRequest(attachment);
            this.restTemplate.exchange(String.format("%s/listener/v2/%s/log", this.endpoint, this.projectName), HttpMethod.POST, request, Response.class, new Object[0]);
        } else {
            LOGGER.warn("The connection with Orangebeard could not be established!");
        }
    }
}

