/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client;

import io.orangebeard.client.OrangebeardProperty;
import io.orangebeard.client.entity.Attribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrangebeardProperties {
    private static final String ORANGEBEARD_PROPERTY_FILE = "orangebeard.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(OrangebeardProperties.class);
    private String endpoint;
    private UUID accessToken;
    private String projectName;
    private String testSetName;
    private String description;
    private Set<Attribute> attributes = new HashSet<Attribute>();
    private boolean propertyFilePresent;

    OrangebeardProperties(String propertyFile) {
        this.readPropertyFile(propertyFile);
        this.readSystemProperties();
        this.readEnvironmentVariables(PropertyNameStyle.DOT);
        this.readEnvironmentVariables(PropertyNameStyle.UNDERSCORE);
    }

    public OrangebeardProperties() {
        this(ORANGEBEARD_PROPERTY_FILE);
    }

    public boolean requiredValuesArePresent() {
        return this.endpoint != null && this.accessToken != null && this.projectName != null && this.testSetName != null;
    }

    public void checkPropertiesArePresent() {
        if (!this.requiredValuesArePresent() && !this.propertyFilePresent) {
            LOGGER.error("Required Orangebeard properties are missing. Not all environment variables are present, and orangebeard.properties cannot be found!\n" + this.requiredPropertiesToString());
        }
        if (!this.requiredValuesArePresent()) {
            LOGGER.error("Required Orangebeard properties are missing. Not all environment variables are present, and/or orangebeard.properties misses required values!\n" + this.requiredPropertiesToString());
        }
    }

    private String requiredPropertiesToString() {
        return OrangebeardProperty.ENDPOINT.getPropertyName() + ": " + this.endpoint + "\n" + OrangebeardProperty.ACCESS_TOKEN.getPropertyName() + ": " + (this.accessToken != null ? "HIDDEN (PRESENT)" : "null\n") + OrangebeardProperty.PROJECT.getPropertyName() + ": " + this.projectName + "\n" + OrangebeardProperty.TESTSET.getPropertyName() + ": " + this.testSetName + "\n";
    }

    private void readPropertyFile(String name) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
            if (inputStream != null) {
                properties.load(inputStream);
                this.propertyFilePresent = true;
            }
            this.readPropertiesWith(properties::getProperty);
        }
        catch (IOException e) {
            this.propertyFilePresent = false;
        }
    }

    private void readSystemProperties() {
        this.readPropertiesWith(System::getProperty);
    }

    private void readEnvironmentVariables(PropertyNameStyle style) {
        if (style == PropertyNameStyle.UNDERSCORE) {
            this.readPropertiesWith(n -> System.getenv(n.replace(".", "_")));
        } else {
            this.readPropertiesWith(System::getenv);
        }
    }

    private void readPropertiesWith(Function<String, String> lookupFunc) {
        this.endpoint = this.lookupWithDefault(OrangebeardProperty.ENDPOINT, lookupFunc, this.endpoint);
        this.accessToken = this.lookupUUIDWithDefault(OrangebeardProperty.ACCESS_TOKEN, lookupFunc, this.accessToken);
        this.projectName = this.lookupWithDefault(OrangebeardProperty.PROJECT, lookupFunc, this.projectName);
        this.testSetName = this.lookupWithDefault(OrangebeardProperty.TESTSET, lookupFunc, this.testSetName);
        this.description = this.lookupWithDefault(OrangebeardProperty.DESCRIPTION, lookupFunc, this.description);
        this.attributes.addAll(this.extractAttributes(lookupFunc.apply(OrangebeardProperty.ATTRIBUTES.getPropertyName())));
    }

    private String lookupWithDefault(OrangebeardProperty property, Function<String, String> lookupFunc, String defaultValue) {
        String temp = lookupFunc.apply(property.getPropertyName());
        return temp == null ? defaultValue : temp;
    }

    private UUID lookupUUIDWithDefault(OrangebeardProperty property, Function<String, String> lookupFunc, UUID defaultValue) {
        String temp = lookupFunc.apply(property.getPropertyName());
        if (temp == null || temp.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return UUID.fromString(temp);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(OrangebeardProperty.ACCESS_TOKEN.getPropertyName() + " is not a valid UUID!");
            return defaultValue;
        }
    }

    private Set<Attribute> extractAttributes(String attributeString) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (attributeString == null || attributeString.isEmpty()) {
            return attributes;
        }
        for (String attribute : attributeString.split(";")) {
            if (attribute.contains(":")) {
                String[] keyValuePair = attribute.trim().split(":", 2);
                attributes.add(new Attribute(keyValuePair[0].trim(), keyValuePair[1].trim()));
                continue;
            }
            attributes.add(new Attribute(attribute.trim()));
        }
        return attributes;
    }

    public String toString() {
        return "OrangebeardProperties(endpoint=" + this.getEndpoint() + ", accessToken=" + this.getAccessToken() + ", projectName=" + this.getProjectName() + ", testSetName=" + this.getTestSetName() + ", description=" + this.getDescription() + ", attributes=" + this.getAttributes() + ", propertyFilePresent=" + this.isPropertyFilePresent() + ")";
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public UUID getAccessToken() {
        return this.accessToken;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTestSetName() {
        return this.testSetName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean isPropertyFilePresent() {
        return this.propertyFilePresent;
    }

    private static enum PropertyNameStyle {
        DOT,
        UNDERSCORE;

    }
}

