/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava2.SpanHolder;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

final class RxTracer {
    static final String COMPONENT_NAME = "rxjava-2";
    private final String operationName;
    private final Tracer tracer;
    private volatile Span span;

    RxTracer(String operationName, Tracer tracer) {
        this.operationName = operationName;
        this.tracer = tracer;
    }

    void onSubscribe() {
        this.span = this.tracer.buildSpan(this.operationName).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).start();
        Scope scope = this.tracer.activateSpan(this.span);
        SpanHolder.set(scope, this.span);
    }

    void onError(Throwable t) {
        RxTracer.onError(t, this.span);
        this.span.finish();
        SpanHolder.clear();
    }

    void onComplete() {
        this.span.finish();
        SpanHolder.clear();
    }

    private static void onError(Throwable throwable, Span span) {
        span.setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
        span.log(RxTracer.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>();
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

