/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.Tracer;
import io.opentracing.rxjava2.AbstractTracingObserver;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

class TracingObserver<T>
extends AbstractTracingObserver<T>
implements Disposable {
    private Disposable upstream;
    private final Observer<T> observer;

    TracingObserver(Observer<T> observer, String operationName, Tracer tracer) {
        super(operationName, tracer);
        this.observer = observer;
    }

    public void dispose() {
        this.upstream.dispose();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void onSubscribe(Disposable d) {
        this.upstream = d;
        try {
            this.observer.onSubscribe((Disposable)this);
        }
        finally {
            super.onSubscribe(d);
        }
    }

    @Override
    public void onNext(T o) {
        this.observer.onNext(o);
    }

    @Override
    public void onError(Throwable t) {
        try {
            this.observer.onError(t);
        }
        finally {
            super.onError(t);
        }
    }

    @Override
    public void onComplete() {
        try {
            this.observer.onComplete();
        }
        finally {
            super.onComplete();
        }
    }
}

