/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava2.SpanStackHolder;
import io.opentracing.rxjava2.TracingObserver;
import io.opentracing.rxjava2.TracingRunnable;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;

public class TracingRxJava2Utils {
    static final String COMPONENT_NAME = "rxjava-2";

    public static void enableTracing() {
        TracingRxJava2Utils.enableTracing(GlobalTracer.get());
    }

    public static void enableTracing(final Tracer tracer) {
        RxJavaPlugins.setScheduleHandler((Function)new Function<Runnable, Runnable>(){

            public Runnable apply(Runnable runnable) throws Exception {
                return new TracingRunnable(runnable);
            }
        });
        RxJavaPlugins.setOnObservableAssembly((Function)new Function<Observable, Observable>(){

            public Observable apply(Observable observable) throws Exception {
                Tracer.SpanBuilder spanBuilder = tracer.buildSpan(observable.getClass().getSimpleName()).withTag(Tags.COMPONENT.getKey(), TracingRxJava2Utils.COMPONENT_NAME);
                Span parent = SpanStackHolder.get();
                if (parent != null) {
                    spanBuilder.addReference("child_of", parent.context());
                }
                Span span = spanBuilder.startManual();
                if (observable.getClass().getSimpleName().isEmpty()) {
                    span.setOperationName(observable.getClass().getName());
                }
                SpanStackHolder.add(span);
                return observable;
            }
        });
        RxJavaPlugins.setOnObservableSubscribe((BiFunction)new BiFunction<Observable, Observer, Observer>(){

            public Observer apply(Observable observable, Observer observer) throws Exception {
                return new TracingObserver(observer);
            }
        });
    }
}

