/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava2.SpanHolder;
import io.opentracing.tag.Tags;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

class TracingObserver
implements Observer<Object>,
Disposable {
    static final String COMPONENT_NAME = "rxjava-2";
    private Disposable upstream;
    private final Observer observer;
    private final Span span;

    TracingObserver(Observable observable, Observer observer, Tracer tracer) {
        this.observer = observer;
        Tracer.SpanBuilder builder = tracer.buildSpan(observable.getClass().getSimpleName()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME);
        Span parent = SpanHolder.get();
        if (parent != null) {
            builder.asChildOf((BaseSpan)parent);
        }
        this.span = builder.startManual();
        SpanHolder.set(this.span);
    }

    public void onSubscribe(Disposable d) {
        this.upstream = d;
        this.observer.onSubscribe((Disposable)this);
    }

    public void onNext(Object o) {
        this.observer.onNext(o);
    }

    public void onError(Throwable t) {
        try {
            this.observer.onError(t);
        }
        finally {
            this.span.finish();
            TracingObserver.onError(t, this.span);
            SpanHolder.clear();
        }
    }

    public void onComplete() {
        try {
            this.observer.onComplete();
        }
        finally {
            this.span.finish();
            SpanHolder.clear();
        }
    }

    public void dispose() {
        this.upstream.dispose();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    private static void onError(Throwable throwable, Span span) {
        span.setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
        span.log(TracingObserver.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>();
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

