/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava2;

import io.opentracing.ActiveSpan;
import io.opentracing.tag.Tags;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

class TracingObserver
implements Observer<Object>,
Disposable {
    private Disposable upstream;
    private final Observer observer;
    private final ActiveSpan.Continuation continuation;

    TracingObserver(Observer observer, ActiveSpan activeSpan) {
        this.observer = observer;
        this.continuation = activeSpan.capture();
    }

    public void onSubscribe(Disposable d) {
        this.upstream = d;
        this.observer.onSubscribe((Disposable)this);
    }

    public void onNext(Object o) {
        this.observer.onNext(o);
    }

    public void onError(Throwable t) {
        try {
            this.observer.onError(t);
        }
        finally {
            ActiveSpan activeSpan = this.continuation.activate();
            TracingObserver.onError(t, activeSpan);
            activeSpan.deactivate();
        }
    }

    public void onComplete() {
        try {
            this.observer.onComplete();
        }
        finally {
            this.continuation.activate().deactivate();
        }
    }

    public void dispose() {
        this.upstream.dispose();
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    private static void onError(Throwable throwable, ActiveSpan span) {
        span.setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
        span.log(TracingObserver.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>();
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

