/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.ActiveSpan;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import rx.Producer;
import rx.Subscriber;

class TracingSubscriber
extends Subscriber {
    private final Subscriber subscriber;
    private final ActiveSpan.Continuation continuation;

    TracingSubscriber(Subscriber subscriber, ActiveSpan activeSpan) {
        this.subscriber = subscriber;
        this.continuation = activeSpan.capture();
    }

    public void onNext(Object o) {
        this.subscriber.onNext(o);
    }

    public void onError(Throwable t) {
        try {
            this.subscriber.onError(t);
        }
        finally {
            ActiveSpan activeSpan = this.continuation.activate();
            TracingSubscriber.onError(t, activeSpan);
            activeSpan.deactivate();
        }
    }

    public void onCompleted() {
        try {
            this.subscriber.onCompleted();
        }
        finally {
            this.continuation.activate().deactivate();
        }
    }

    public void setProducer(Producer p) {
        this.subscriber.setProducer(p);
    }

    private static void onError(Throwable throwable, ActiveSpan span) {
        span.setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
        span.log(TracingSubscriber.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>();
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

