/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MultiSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(MultiSpanExporter.class.getName());
    private final SpanExporter[] spanExporters;

    public static SpanExporter create(List<SpanExporter> spanExporters) {
        return new MultiSpanExporter(spanExporters);
    }

    @Override
    public SpanExporter.ResultCode export(List<SpanData> spans) {
        SpanExporter.ResultCode currentResultCode = SpanExporter.ResultCode.SUCCESS;
        for (SpanExporter spanExporter : this.spanExporters) {
            try {
                currentResultCode = MultiSpanExporter.mergeResultCode(currentResultCode, spanExporter.export(spans));
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception thrown by the export.", t);
                currentResultCode = SpanExporter.ResultCode.FAILED_NOT_RETRYABLE;
            }
        }
        return currentResultCode;
    }

    @Override
    public void shutdown() {
        for (SpanExporter spanExporter : this.spanExporters) {
            spanExporter.shutdown();
        }
    }

    private static SpanExporter.ResultCode mergeResultCode(SpanExporter.ResultCode currentResultCode, SpanExporter.ResultCode newResultCode) {
        if (currentResultCode == SpanExporter.ResultCode.SUCCESS && newResultCode == SpanExporter.ResultCode.SUCCESS) {
            return SpanExporter.ResultCode.SUCCESS;
        }
        if (currentResultCode == SpanExporter.ResultCode.FAILED_NOT_RETRYABLE || newResultCode == SpanExporter.ResultCode.FAILED_NOT_RETRYABLE) {
            return SpanExporter.ResultCode.FAILED_NOT_RETRYABLE;
        }
        return SpanExporter.ResultCode.FAILED_RETRYABLE;
    }

    private MultiSpanExporter(List<SpanExporter> spanExporters) {
        this.spanExporters = spanExporters.toArray(new SpanExporter[spanExporters.size()]);
    }
}

