/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import com.google.common.util.concurrent.MoreExecutors;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.LongCounter;
import io.opentelemetry.metrics.Meter;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public final class BatchSpansProcessor
implements SpanProcessor {
    private static final String WORKER_THREAD_NAME = BatchSpansProcessor.class.getSimpleName() + "_WorkerThread";
    private static final String EXPORTER_THREAD_NAME = BatchSpansProcessor.class.getSimpleName() + "_ExporterThread";
    private final Worker worker;
    private final Thread workerThread;
    private final boolean sampled;

    private BatchSpansProcessor(SpanExporter spanExporter, boolean sampled, long scheduleDelayMillis, int maxQueueSize, int maxExportBatchSize, int exporterTimeoutMillis) {
        this.worker = new Worker(spanExporter, scheduleDelayMillis, maxQueueSize, maxExportBatchSize, exporterTimeoutMillis);
        this.workerThread = BatchSpansProcessor.newThread(this.worker);
        this.workerThread.start();
        this.sampled = sampled;
    }

    @Override
    public void onStart(ReadableSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().getTraceFlags().isSampled()) {
            return;
        }
        this.worker.addSpan(span);
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public void shutdown() {
        this.workerThread.interrupt();
        this.worker.shutdown();
    }

    @Override
    public void forceFlush() {
        this.worker.forceFlush();
    }

    public static Builder newBuilder(SpanExporter spanExporter) {
        return new Builder(spanExporter);
    }

    private static Thread newThread(Runnable runnable) {
        Thread thread = MoreExecutors.platformThreadFactory().newThread(runnable);
        try {
            thread.setName(WORKER_THREAD_NAME);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return thread;
    }

    private static final class Worker
    implements Runnable {
        private static final LongCounter.BoundLongCounter droppedSpans;
        private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, EXPORTER_THREAD_NAME);
            }
        });
        private static final Logger logger;
        private final SpanExporter spanExporter;
        private final long scheduleDelayMillis;
        private final int maxQueueSize;
        private final int maxExportBatchSize;
        private final int halfMaxQueueSize;
        private final Object monitor = new Object();
        private final int exporterTimeoutMillis;
        @GuardedBy(value="monitor")
        private final List<ReadableSpan> spansList;

        private Worker(SpanExporter spanExporter, long scheduleDelayMillis, int maxQueueSize, int maxExportBatchSize, int exporterTimeoutMillis) {
            this.spanExporter = spanExporter;
            this.scheduleDelayMillis = scheduleDelayMillis;
            this.maxQueueSize = maxQueueSize;
            this.halfMaxQueueSize = maxQueueSize >> 1;
            this.maxExportBatchSize = maxExportBatchSize;
            this.spansList = new ArrayList<ReadableSpan>(maxQueueSize);
            this.exporterTimeoutMillis = exporterTimeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(ReadableSpan span) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.spansList.size() == this.maxQueueSize) {
                    droppedSpans.add(1L);
                    return;
                }
                this.spansList.add(span);
                if (this.spansList.size() >= this.halfMaxQueueSize) {
                    this.monitor.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                ArrayList<ReadableSpan> spansCopy;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.spansList.size() < this.maxExportBatchSize) {
                        do {
                            try {
                                this.monitor.wait(this.scheduleDelayMillis);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        } while (this.spansList.isEmpty());
                    }
                    spansCopy = new ArrayList<ReadableSpan>(this.spansList);
                    this.spansList.clear();
                }
                this.exportBatches(spansCopy);
            }
        }

        private void shutdown() {
            this.forceFlush();
            this.executorService.shutdown();
            this.spanExporter.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceFlush() {
            ArrayList<ReadableSpan> spansCopy;
            Object object = this.monitor;
            synchronized (object) {
                spansCopy = new ArrayList<ReadableSpan>(this.spansList);
                this.spansList.clear();
            }
            this.exportBatches(spansCopy);
        }

        private void exportBatches(ArrayList<ReadableSpan> spanList) {
            int i = 0;
            while (i < spanList.size()) {
                int batchSizeLimit = Math.min(i + this.maxExportBatchSize, spanList.size());
                this.onBatchExport(Worker.createSpanDataForExport(spanList, i, batchSizeLimit));
                i = batchSizeLimit;
            }
        }

        private static List<SpanData> createSpanDataForExport(List<ReadableSpan> spanList, int startIndex, int numberToTake) {
            ArrayList<SpanData> spanDataBuffer = new ArrayList<SpanData>(numberToTake);
            for (int i = startIndex; i < numberToTake; ++i) {
                spanDataBuffer.add(spanList.get(i).toSpanData());
                spanList.set(i, null);
            }
            return Collections.unmodifiableList(spanDataBuffer);
        }

        private void onBatchExport(final List<SpanData> spans) {
            Future<?> submission = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Worker.this.spanExporter.export(spans);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Exception thrown by the export.", t);
                    }
                }
            });
            try {
                submission.get(this.exporterTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.WARNING, "Exception thrown by the export.", e);
            }
            catch (TimeoutException e) {
                logger.log(Level.WARNING, "Export timed out. Cancelling execution.", e);
                submission.cancel(true);
            }
        }

        static {
            Meter meter = OpenTelemetry.getMeterProvider().get("io.opentelemetry.sdk.trace");
            LongCounter droppedSpansCounter = meter.longCounterBuilder("droppedSpans").setMonotonic(true).setUnit("1").setDescription("The number of spans dropped by the BatchSpansProcessor due to high throughput.").build();
            droppedSpans = droppedSpansCounter.bind(new String[]{"spanProcessorType", BatchSpansProcessor.class.getSimpleName()});
            logger = Logger.getLogger(Worker.class.getName());
        }
    }

    public static final class Builder {
        private static final long SCHEDULE_DELAY_MILLIS = 5000L;
        private static final int MAX_QUEUE_SIZE = 2048;
        private static final int MAX_EXPORT_BATCH_SIZE = 512;
        private static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
        private final SpanExporter spanExporter;
        private long scheduleDelayMillis = 5000L;
        private int maxQueueSize = 2048;
        private int maxExportBatchSize = 512;
        private int exporterTimeoutMillis = 30000;
        private boolean sampled = true;

        private Builder(SpanExporter spanExporter) {
            this.spanExporter = (SpanExporter)Utils.checkNotNull((Object)spanExporter, (Object)"spanExporter");
        }

        public Builder reportOnlySampled(boolean sampled) {
            this.sampled = sampled;
            return this;
        }

        public Builder setScheduleDelayMillis(long scheduleDelayMillis) {
            this.scheduleDelayMillis = scheduleDelayMillis;
            return this;
        }

        public Builder setExporterTimeoutMillis(int exporterTimeoutMillis) {
            this.exporterTimeoutMillis = exporterTimeoutMillis;
            return this;
        }

        public Builder setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder setMaxExportBatchSize(int maxExportBatchSize) {
            Utils.checkArgument((maxExportBatchSize > 0 ? 1 : 0) != 0, (Object)"maxExportBatchSize must be positive.");
            this.maxExportBatchSize = maxExportBatchSize;
            return this;
        }

        public BatchSpansProcessor build() {
            return new BatchSpansProcessor(this.spanExporter, this.sampled, this.scheduleDelayMillis, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutMillis);
        }
    }
}

