/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.SpanBuilderSdk;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.trace.DefaultTracer;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracingContextUtils;
import io.opentelemetry.trace.propagation.HttpTraceContext;

public final class TracerSdk
implements Tracer {
    private static final HttpTextFormat<SpanContext> HTTP_TEXT_FORMAT = new HttpTraceContext();
    private final TracerSharedState sharedState;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    TracerSdk(TracerSharedState sharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.sharedState = sharedState;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
    }

    public Span getCurrentSpan() {
        return TracingContextUtils.getCurrentSpan();
    }

    public Scope withSpan(Span span) {
        return TracingContextUtils.currentContextWith((Span)span);
    }

    public Span.Builder spanBuilder(String spanName) {
        if (this.sharedState.isStopped()) {
            return DefaultTracer.getInstance().spanBuilder(spanName);
        }
        return new SpanBuilderSdk(spanName, this.instrumentationLibraryInfo, this.sharedState.getActiveSpanProcessor(), this.sharedState.getActiveTraceConfig(), this.sharedState.getResource(), this.sharedState.getIdsGenerator(), this.sharedState.getClock());
    }

    public HttpTextFormat<SpanContext> getHttpTextFormat() {
        return HTTP_TEXT_FORMAT;
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }
}

