/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.resources.AutoValue_Resource;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Collections.emptyMap());

    Resource() {
    }

    public static Resource getEmpty() {
        return EMPTY;
    }

    public abstract Map<String, AttributeValue> getAttributes();

    public static Resource create(Map<String, AttributeValue> attributes) {
        Resource.checkAttributes((Map)Utils.checkNotNull(attributes, (Object)"attributes"));
        return new AutoValue_Resource(Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(attributes)));
    }

    public Resource merge(@Nullable Resource other) {
        if (other == null) {
            return this;
        }
        LinkedHashMap<String, AttributeValue> mergedAttributeMap = new LinkedHashMap<String, AttributeValue>(other.getAttributes());
        for (Map.Entry<String, AttributeValue> entry : this.getAttributes().entrySet()) {
            mergedAttributeMap.put(entry.getKey(), entry.getValue());
        }
        return new AutoValue_Resource(Collections.unmodifiableMap(mergedAttributeMap));
    }

    private static void checkAttributes(Map<String, AttributeValue> attributes) {
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            Utils.checkArgument((boolean)Resource.isValidAndNotEmpty(entry.getKey()), (Object)"Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            Utils.checkNotNull((Object)entry.getValue(), (Object)"Attribute value should be a ASCII string with a length not exceed 255 characters.");
        }
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString((String)name);
    }

    private static boolean isValidAndNotEmpty(String name) {
        return !name.isEmpty() && Resource.isValid(name);
    }
}

