/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.internal.MillisClock;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSdk;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.resources.EnvVarResource;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

public final class MeterSdkProvider
implements MeterProvider {
    private final MeterSdkComponentRegistry registry;
    private final MetricProducer metricProducer;

    private MeterSdkProvider(Clock clock, Resource resource) {
        this.registry = new MeterSdkComponentRegistry(MeterProviderSharedState.create(clock, resource));
        this.metricProducer = new MetricProducerSdk(this.registry);
    }

    public MeterSdk get(String instrumentationName) {
        return (MeterSdk)this.registry.get(instrumentationName);
    }

    public MeterSdk get(String instrumentationName, String instrumentationVersion) {
        return (MeterSdk)this.registry.get(instrumentationName, instrumentationVersion);
    }

    public MetricProducer getMetricProducer() {
        return this.metricProducer;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class MetricProducerSdk
    implements MetricProducer {
        private final MeterSdkComponentRegistry registry;

        private MetricProducerSdk(MeterSdkComponentRegistry registry) {
            this.registry = registry;
        }

        @Override
        public Collection<MetricData> getAllMetrics() {
            Collection meters = this.registry.getComponents();
            ArrayList<MetricData> result = new ArrayList<MetricData>(meters.size());
            for (MeterSdk meter : meters) {
                result.addAll(meter.collectAll());
            }
            return Collections.unmodifiableCollection(result);
        }
    }

    private static final class MeterSdkComponentRegistry
    extends ComponentRegistry<MeterSdk> {
        private final MeterProviderSharedState meterProviderSharedState;

        private MeterSdkComponentRegistry(MeterProviderSharedState meterProviderSharedState) {
            this.meterProviderSharedState = meterProviderSharedState;
        }

        @Override
        public MeterSdk newComponent(InstrumentationLibraryInfo instrumentationLibraryInfo) {
            return new MeterSdk(this.meterProviderSharedState, instrumentationLibraryInfo);
        }
    }

    public static final class Builder {
        private Clock clock = MillisClock.getInstance();
        private Resource resource = EnvVarResource.getResource();

        private Builder() {
        }

        public Builder setClock(@Nonnull Clock clock) {
            Utils.checkNotNull((Object)clock, (Object)"clock");
            this.clock = clock;
            return this;
        }

        public Builder setResource(@Nonnull Resource resource) {
            Utils.checkNotNull((Object)resource, (Object)"resource");
            this.resource = resource;
            return this;
        }

        public MeterSdkProvider build() {
            return new MeterSdkProvider(this.clock, this.resource);
        }
    }
}

