/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.Instrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractInstrument
implements Instrument {
    private final InstrumentDescriptor descriptor;
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;
    private final ActiveBatcher activeBatcher;

    AbstractInstrument(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
        this.descriptor = descriptor;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
        this.activeBatcher = activeBatcher;
    }

    final InstrumentDescriptor getDescriptor() {
        return this.descriptor;
    }

    final MeterProviderSharedState getMeterProviderSharedState() {
        return this.meterProviderSharedState;
    }

    final MeterSharedState getMeterSharedState() {
        return this.meterSharedState;
    }

    final ActiveBatcher getActiveBatcher() {
        return this.activeBatcher;
    }

    abstract List<MetricData> collectAll();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractInstrument)) {
            return false;
        }
        AbstractInstrument that = (AbstractInstrument)o;
        return this.descriptor.equals(that.descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    static MetricData.Descriptor getDefaultMetricDescriptor(InstrumentDescriptor descriptor, InstrumentType instrumentType, InstrumentValueType instrumentValueType, Aggregation aggregation) {
        return MetricData.Descriptor.create(descriptor.getName(), descriptor.getDescription(), aggregation.getUnit(descriptor.getUnit()), aggregation.getDescriptorType(instrumentType, instrumentValueType), descriptor.getConstantLabels());
    }

    static Batcher getDefaultBatcher(InstrumentDescriptor descriptor, InstrumentType instrumentType, InstrumentValueType instrumentValueType, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation defaultAggregation) {
        return Batchers.getCumulativeAllLabels(AbstractInstrument.getDefaultMetricDescriptor(descriptor, instrumentType, instrumentValueType, defaultAggregation), meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), defaultAggregation.getAggregatorFactory(instrumentValueType), meterProviderSharedState.getClock());
    }

    static abstract class Builder<B extends Builder<?>>
    implements Instrument.Builder {
        static final int NAME_MAX_LENGTH = 255;
        static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";
        private final String name;
        private final MeterProviderSharedState meterProviderSharedState;
        private final MeterSharedState meterSharedState;
        private String description = "";
        private String unit = "1";
        private List<String> labelKeys = Collections.emptyList();
        private Map<String, String> constantLabels = Collections.emptyMap();

        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            Utils.checkNotNull((Object)name, (Object)"name");
            Utils.checkArgument((StringUtils.isValidMetricName((String)name) && name.length() <= 255 ? 1 : 0) != 0, (Object)ERROR_MESSAGE_INVALID_NAME);
            this.name = name;
            this.meterProviderSharedState = meterProviderSharedState;
            this.meterSharedState = meterSharedState;
        }

        public final B setDescription(String description) {
            this.description = (String)Utils.checkNotNull((Object)description, (Object)"description");
            return this.getThis();
        }

        public final B setUnit(String unit) {
            this.unit = (String)Utils.checkNotNull((Object)unit, (Object)"unit");
            return this.getThis();
        }

        public final B setLabelKeys(List<String> labelKeys) {
            Utils.checkListElementNotNull((List)((List)Utils.checkNotNull(labelKeys, (Object)"labelKeys")), (Object)"labelKey");
            this.labelKeys = Collections.unmodifiableList(new ArrayList<String>(labelKeys));
            return this.getThis();
        }

        public final B setConstantLabels(Map<String, String> constantLabels) {
            Utils.checkMapKeysNotNull((Map)((Map)Utils.checkNotNull(constantLabels, (Object)"constantLabels")), (Object)"constantLabel");
            this.constantLabels = Collections.unmodifiableMap(new HashMap<String, String>(constantLabels));
            return this.getThis();
        }

        final MeterProviderSharedState getMeterProviderSharedState() {
            return this.meterProviderSharedState;
        }

        final MeterSharedState getMeterSharedState() {
            return this.meterSharedState;
        }

        final InstrumentDescriptor getInstrumentDescriptor() {
            return InstrumentDescriptor.create(this.name, this.description, this.unit, this.constantLabels, this.labelKeys);
        }

        abstract B getThis();

        final <I extends AbstractInstrument> I register(I instrument) {
            return this.getMeterSharedState().getInstrumentRegistry().register(instrument);
        }
    }
}

