/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanData;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TimedEvent;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.trace.AttributeValue;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.Event;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class RecordEventsReadableSpan
implements ReadableSpan,
Span {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private final SpanContext context;
    private final SpanId parentSpanId;
    private final boolean hasRemoteParent;
    private final SpanProcessor spanProcessor;
    private final List<Link> links;
    private final int totalRecordedLinks;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String name;
    private final Span.Kind kind;
    private final Clock clock;
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final long startEpochNanos;
    @GuardedBy(value="lock")
    private final AttributesWithCapacity attributes;
    @GuardedBy(value="lock")
    private final EvictingQueue<TimedEvent> events;
    @GuardedBy(value="lock")
    private int totalRecordedEvents = 0;
    @GuardedBy(value="lock")
    private int numberOfChildren;
    @Nullable
    @GuardedBy(value="lock")
    private Status status;
    @GuardedBy(value="lock")
    private long endEpochNanos;
    @GuardedBy(value="lock")
    private boolean hasBeenEnded;

    @VisibleForTesting
    static RecordEventsReadableSpan startSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, Span.Kind kind, @Nullable SpanId parentSpanId, boolean hasRemoteParent, TraceConfig traceConfig, SpanProcessor spanProcessor, Clock clock, Resource resource, Map<String, AttributeValue> attributes, List<Link> links, int totalRecordedLinks, long startEpochNanos) {
        RecordEventsReadableSpan span = new RecordEventsReadableSpan(context, name, instrumentationLibraryInfo, kind, parentSpanId == null ? SpanId.getInvalid() : parentSpanId, hasRemoteParent, traceConfig, spanProcessor, clock, resource, attributes, links, totalRecordedLinks, startEpochNanos == 0L ? clock.now() : startEpochNanos);
        spanProcessor.onStart(span);
        return span;
    }

    @Override
    public SpanData toSpanData() {
        SpanContext spanContext = this.getSpanContext();
        return SpanData.newBuilder().setName(this.getName()).setInstrumentationLibraryInfo(this.instrumentationLibraryInfo).setTraceId(spanContext.getTraceId()).setSpanId(spanContext.getSpanId()).setTraceFlags(spanContext.getTraceFlags()).setTracestate(spanContext.getTracestate()).setAttributes(this.getAttributes()).setStartEpochNanos(this.startEpochNanos).setEndEpochNanos(this.getEndEpochNanos()).setKind(this.kind).setLinks(this.getLinks()).setParentSpanId(this.parentSpanId).setHasRemoteParent(this.hasRemoteParent).setResource(this.resource).setStatus(this.getStatus()).setTimedEvents(this.adaptTimedEvents()).build();
    }

    private List<SpanData.TimedEvent> adaptTimedEvents() {
        List<TimedEvent> sourceEvents = this.getTimedEvents();
        ArrayList<SpanData.TimedEvent> result = new ArrayList<SpanData.TimedEvent>(sourceEvents.size());
        for (TimedEvent sourceEvent : sourceEvents) {
            result.add(SpanData.TimedEvent.create(sourceEvent.getEpochNanos(), sourceEvent.getName(), sourceEvent.getAttributes()));
        }
        return result;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEndEpochNanos() {
        Object object = this.lock;
        synchronized (object) {
            return this.getEndNanoTimeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.getStatusWithDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TimedEvent> getTimedEvents() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<TimedEvent>((Collection<TimedEvent>)this.events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<Link> getLinks() {
        Object object = this.lock;
        synchronized (object) {
            if (this.links == null) {
                return Collections.emptyList();
            }
            ArrayList<Link> result = new ArrayList<Link>(this.links.size());
            Iterator<Link> iterator = this.links.iterator();
            while (iterator.hasNext()) {
                Link link;
                Link newLink = link = iterator.next();
                if (!(link instanceof SpanData.Link)) {
                    newLink = SpanData.Link.create(link.getContext(), link.getAttributes());
                }
                result.add(newLink);
            }
            return Collections.unmodifiableList(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<String, AttributeValue> getAttributes() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLatencyNs() {
        Object object = this.lock;
        synchronized (object) {
            return this.getEndNanoTimeInternal() - this.startEpochNanos;
        }
    }

    @GuardedBy(value="lock")
    private long getEndNanoTimeInternal() {
        return this.hasBeenEnded ? this.endEpochNanos : this.clock.now();
    }

    public Span.Kind getKind() {
        return this.kind;
    }

    @VisibleForTesting
    public SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    @VisibleForTesting
    public Clock getClock() {
        return this.clock;
    }

    public void setAttribute(String key, String value) {
        this.setAttribute(key, AttributeValue.stringAttributeValue((String)value));
    }

    public void setAttribute(String key, long value) {
        this.setAttribute(key, AttributeValue.longAttributeValue((long)value));
    }

    public void setAttribute(String key, double value) {
        this.setAttribute(key, AttributeValue.doubleAttributeValue((double)value));
    }

    public void setAttribute(String key, boolean value) {
        this.setAttribute(key, AttributeValue.booleanAttributeValue((boolean)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, AttributeValue value) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        Object object = this.lock;
        synchronized (object) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling setAttribute() on an ended Span.");
                return;
            }
            this.attributes.putAttribute(key, value);
        }
    }

    public void addEvent(String name) {
        this.addTimedEvent(TimedEvent.create(this.clock.now(), name));
    }

    public void addEvent(String name, long timestamp) {
        this.addTimedEvent(TimedEvent.create(timestamp, name));
    }

    public void addEvent(String name, Map<String, AttributeValue> attributes) {
        this.addTimedEvent(TimedEvent.create(this.clock.now(), name, attributes));
    }

    public void addEvent(String name, Map<String, AttributeValue> attributes, long timestamp) {
        this.addTimedEvent(TimedEvent.create(timestamp, name, attributes));
    }

    public void addEvent(Event event) {
        this.addTimedEvent(TimedEvent.create(this.clock.now(), event));
    }

    public void addEvent(Event event, long timestamp) {
        this.addTimedEvent(TimedEvent.create(timestamp, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(TimedEvent timedEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling addEvent() on an ended Span.");
                return;
            }
            this.events.add((Object)timedEvent);
            ++this.totalRecordedEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Object object = this.lock;
        synchronized (object) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return;
            }
            this.status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Object object = this.lock;
        synchronized (object) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling updateName() on an ended Span.");
                return;
            }
            this.name = name;
        }
    }

    public void end() {
        this.endInternal(this.clock.now());
    }

    public void end(EndSpanOptions endOptions) {
        Preconditions.checkNotNull((Object)endOptions, (Object)"endOptions");
        this.endInternal(endOptions.getEndTimestamp() == 0L ? this.clock.now() : endOptions.getEndTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long endEpochNanos) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            this.endEpochNanos = endEpochNanos;
            this.hasBeenEnded = true;
        }
        this.spanProcessor.onEnd(this);
    }

    public SpanContext getContext() {
        return this.context;
    }

    public boolean isRecording() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild() {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasBeenEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            ++this.numberOfChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private Status getStatusWithDefault() {
        Object object = this.lock;
        synchronized (object) {
            return this.status == null ? Status.OK : this.status;
        }
    }

    private RecordEventsReadableSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, Span.Kind kind, SpanId parentSpanId, boolean hasRemoteParent, TraceConfig traceConfig, SpanProcessor spanProcessor, Clock clock, Resource resource, Map<String, AttributeValue> attributes, List<Link> links, int totalRecordedLinks, long startEpochNanos) {
        this.context = context;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.parentSpanId = parentSpanId;
        this.hasRemoteParent = hasRemoteParent;
        this.links = links;
        this.totalRecordedLinks = totalRecordedLinks;
        this.name = name;
        this.kind = kind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasBeenEnded = false;
        this.numberOfChildren = 0;
        this.clock = clock;
        this.startEpochNanos = startEpochNanos;
        this.attributes = new AttributesWithCapacity((long)traceConfig.getMaxNumberOfAttributes());
        this.attributes.putAll(attributes);
        this.events = EvictingQueue.create((int)traceConfig.getMaxNumberOfEvents());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.lock;
        synchronized (object) {
            if (!this.hasBeenEnded) {
                logger.log(Level.SEVERE, "Span " + this.name + " is GC'ed without being ended.");
            }
        }
        super.finalize();
    }

    @VisibleForTesting
    int getDroppedLinksCount() {
        return this.totalRecordedLinks - this.links.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfChildren() {
        Object object = this.lock;
        synchronized (object) {
            return this.numberOfChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getTotalRecordedEvents() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalRecordedEvents;
        }
    }

    static final class AttributesWithCapacity
    extends LinkedHashMap<String, AttributeValue> {
        private final long capacity;
        private int totalRecordedAttributes = 0;
        private static final long serialVersionUID = 42L;

        private AttributesWithCapacity(long capacity) {
            super((int)capacity + 1, 1.0f, true);
            this.capacity = capacity;
        }

        private void putAttribute(String key, AttributeValue value) {
            ++this.totalRecordedAttributes;
            this.put(key, value);
        }

        int getNumberOfDroppedAttributes() {
            return this.totalRecordedAttributes - this.size();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AttributeValue> eldest) {
            return (long)this.size() > this.capacity;
        }
    }
}

