/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit5;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import io.opentelemetry.sdk.testing.assertj.TracesAssert;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class OpenTelemetryExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;
    private final InMemoryMetricReader metricReader;

    public static OpenTelemetryExtension create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        InMemoryMetricReader metricReader = InMemoryMetricReader.create();
        SdkMeterProvider meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)metricReader).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).setMeterProvider(meterProvider).build();
        return new OpenTelemetryExtension(openTelemetry, spanExporter, metricReader);
    }

    private OpenTelemetryExtension(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter, InMemoryMetricReader metricReader) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
        this.metricReader = metricReader;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public List<MetricData> getMetrics() {
        return new ArrayList<MetricData>(this.metricReader.collectAllMetrics());
    }

    public TracesAssert assertTraces() {
        return TracesAssert.assertThat(this.spanExporter.getFinishedSpanItems());
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    public void clearMetrics() {
        SdkMeterProviderUtil.resetForTest((SdkMeterProvider)this.openTelemetry.getSdkMeterProvider());
    }

    public void beforeEach(ExtensionContext context) {
        this.clearSpans();
        this.clearMetrics();
    }

    public void beforeAll(ExtensionContext context) {
        GlobalOpenTelemetry.resetForTest();
        GlobalOpenTelemetry.set((OpenTelemetry)this.openTelemetry);
    }

    public void afterAll(ExtensionContext context) {
        GlobalOpenTelemetry.resetForTest();
        this.openTelemetry.close();
    }
}

