/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractIterableAssert;

public class TraceAssert
extends AbstractIterableAssert<TraceAssert, List<SpanData>, SpanData, SpanDataAssert> {
    TraceAssert(List<SpanData> spanData) {
        super(spanData, TraceAssert.class);
    }

    public TraceAssert hasTraceId(String traceId) {
        this.isNotNull();
        this.isNotEmpty();
        String actualTraceId = ((SpanData)((List)this.actual).get(0)).getTraceId();
        if (!actualTraceId.equals(traceId)) {
            this.failWithActualExpectedAndMessage(actualTraceId, traceId, "Expected trace to have trace ID <%s> but was <%s>", new Object[]{traceId, actualTraceId});
        }
        return this;
    }

    @SafeVarargs
    public final TraceAssert hasSpansSatisfyingExactly(Consumer<SpanDataAssert> ... assertions) {
        this.hasSize(assertions.length);
        this.zipSatisfy(Arrays.asList(assertions), (span, assertion) -> assertion.accept(new SpanDataAssert((SpanData)span)));
        return this;
    }

    protected SpanDataAssert toAssert(SpanData value, String description) {
        return (SpanDataAssert)((Object)new SpanDataAssert(value).as(description, new Object[0]));
    }

    protected TraceAssert newAbstractIterableAssert(Iterable<? extends SpanData> iterable) {
        return new TraceAssert(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));
    }
}

