/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.internal.ExceptionAttributeResolver;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class DefaultExceptionAttributeResolver
implements ExceptionAttributeResolver {
    private static final DefaultExceptionAttributeResolver INSTANCE = new DefaultExceptionAttributeResolver();

    private DefaultExceptionAttributeResolver() {
    }

    public static ExceptionAttributeResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public void setExceptionAttributes(ExceptionAttributeResolver.AttributeSetter attributeSetter, Throwable throwable, int maxAttributeLength) {
        String exceptionMessage;
        String exceptionType = throwable.getClass().getCanonicalName();
        if (exceptionType != null) {
            attributeSetter.setAttribute(ExceptionAttributeResolver.EXCEPTION_TYPE, exceptionType);
        }
        if ((exceptionMessage = throwable.getMessage()) != null) {
            attributeSetter.setAttribute(ExceptionAttributeResolver.EXCEPTION_MESSAGE, exceptionMessage);
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        String exceptionStacktrace = stringWriter.toString();
        if (exceptionStacktrace != null) {
            attributeSetter.setAttribute(ExceptionAttributeResolver.EXCEPTION_STACKTRACE, exceptionStacktrace);
        }
    }
}

