/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.aws;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AwsXrayPropagator
implements TextMapPropagator {
    static final String TRACE_HEADER_KEY = "X-Amzn-Trace-Id";
    private static final Logger logger = Logger.getLogger(AwsXrayPropagator.class.getName());
    private static final char TRACE_HEADER_DELIMITER = ';';
    private static final char KV_DELIMITER = '=';
    private static final String TRACE_ID_KEY = "Root";
    private static final int TRACE_ID_LENGTH = 35;
    private static final String TRACE_ID_VERSION = "1";
    private static final char TRACE_ID_DELIMITER = '-';
    private static final int TRACE_ID_DELIMITER_INDEX_1 = 1;
    private static final int TRACE_ID_DELIMITER_INDEX_2 = 10;
    private static final int TRACE_ID_FIRST_PART_LENGTH = 8;
    private static final String PARENT_ID_KEY = "Parent";
    private static final int PARENT_ID_LENGTH = 16;
    private static final String SAMPLED_FLAG_KEY = "Sampled";
    private static final int SAMPLED_FLAG_LENGTH = 1;
    private static final char IS_SAMPLED = '1';
    private static final char NOT_SAMPLED = '0';
    private static final Collection<String> FIELDS = Collections.singletonList("X-Amzn-Trace-Id");
    private static final AwsXrayPropagator INSTANCE = new AwsXrayPropagator();

    private AwsXrayPropagator() {
    }

    public static AwsXrayPropagator getInstance() {
        return INSTANCE;
    }

    public Collection<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null) {
            return;
        }
        if (setter == null) {
            return;
        }
        Span span = Span.fromContext((Context)context);
        if (!span.getSpanContext().isValid()) {
            return;
        }
        SpanContext spanContext = span.getSpanContext();
        String otTraceId = spanContext.getTraceId();
        String xrayTraceId = "1-" + otTraceId.substring(0, 8) + '-' + otTraceId.substring(8);
        String parentId = spanContext.getSpanId();
        char samplingFlag = spanContext.isSampled() ? (char)'1' : '0';
        String traceHeader = "Root=" + xrayTraceId + ';' + PARENT_ID_KEY + '=' + parentId + ';' + SAMPLED_FLAG_KEY + '=' + samplingFlag;
        setter.set(carrier, TRACE_HEADER_KEY, traceHeader);
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        SpanContext spanContext = AwsXrayPropagator.getSpanContextFromHeader(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return context.with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext));
    }

    private static <C> SpanContext getSpanContextFromHeader(@Nullable C carrier, TextMapGetter<C> getter) {
        String traceHeader = getter.get(carrier, TRACE_HEADER_KEY);
        if (traceHeader == null || traceHeader.isEmpty()) {
            return SpanContext.getInvalid();
        }
        String traceId = TraceId.getInvalid();
        String spanId = SpanId.getInvalid();
        Boolean isSampled = false;
        int pos = 0;
        while (pos < traceHeader.length()) {
            String part;
            int delimiterIndex = traceHeader.indexOf(59, pos);
            if (delimiterIndex >= 0) {
                part = traceHeader.substring(pos, delimiterIndex);
                pos = delimiterIndex + 1;
            } else {
                part = traceHeader.substring(pos);
                pos = traceHeader.length();
            }
            String trimmedPart = part.trim();
            int equalsIndex = trimmedPart.indexOf(61);
            if (equalsIndex < 0) {
                logger.fine("Error parsing X-Ray trace header. Invalid key value pair: " + part + " Returning INVALID span context.");
                return SpanContext.getInvalid();
            }
            String value = trimmedPart.substring(equalsIndex + 1);
            if (trimmedPart.startsWith(TRACE_ID_KEY)) {
                traceId = AwsXrayPropagator.parseTraceId(value);
                continue;
            }
            if (trimmedPart.startsWith(PARENT_ID_KEY)) {
                spanId = AwsXrayPropagator.parseSpanId(value);
                continue;
            }
            if (!trimmedPart.startsWith(SAMPLED_FLAG_KEY)) continue;
            isSampled = AwsXrayPropagator.parseTraceFlag(value);
        }
        if (isSampled == null) {
            logger.fine("Invalid Sampling flag in X-Ray trace header: 'X-Amzn-Trace-Id' with value " + traceHeader + "'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        return SpanContext.createFromRemoteParent((String)traceId, (String)spanId, (TraceFlags)(isSampled != false ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault());
    }

    private static String parseTraceId(String xrayTraceId) {
        if (xrayTraceId.length() != 35) {
            return TraceId.getInvalid();
        }
        if (!xrayTraceId.startsWith(TRACE_ID_VERSION)) {
            return TraceId.getInvalid();
        }
        if (xrayTraceId.charAt(1) != '-' || xrayTraceId.charAt(10) != '-') {
            return TraceId.getInvalid();
        }
        String epochPart = xrayTraceId.substring(2, 10);
        String uniquePart = xrayTraceId.substring(11, 35);
        return epochPart + uniquePart;
    }

    private static String parseSpanId(String xrayParentId) {
        if (xrayParentId.length() != 16) {
            return SpanId.getInvalid();
        }
        return xrayParentId;
    }

    @Nullable
    private static Boolean parseTraceFlag(String xraySampledFlag) {
        if (xraySampledFlag.length() != 1) {
            return null;
        }
        char flag = xraySampledFlag.charAt(0);
        if (flag == '1') {
            return true;
        }
        if (flag == '0') {
            return false;
        }
        return null;
    }
}

