/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class JaegerGrpcSpanExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "localhost:14250";
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private String endpoint = "localhost:14250";
    private ManagedChannel channel;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);

    public JaegerGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public JaegerGrpcSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public JaegerGrpcSpanExporter build() {
        if (this.channel == null) {
            this.channel = ManagedChannelBuilder.forTarget((String)this.endpoint).usePlaintext().build();
        }
        return new JaegerGrpcSpanExporter(this.channel, this.timeoutNanos);
    }

    JaegerGrpcSpanExporterBuilder() {
    }
}

