/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.exporter.jaeger.proto.api_v2.Model;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class Adapter {
    static final AttributeKey<Boolean> KEY_ERROR = AttributeKey.booleanKey((String)"error");
    static final String KEY_LOG_EVENT = "event";
    static final String KEY_EVENT_DROPPED_ATTRIBUTES_COUNT = "otel.event.dropped_attributes_count";
    static final String KEY_SPAN_KIND = "span.kind";
    static final String KEY_SPAN_STATUS_MESSAGE = "otel.status_description";
    static final String KEY_SPAN_STATUS_CODE = "otel.status_code";
    static final String KEY_INSTRUMENTATION_LIBRARY_NAME = "otel.library.name";
    static final String KEY_INSTRUMENTATION_LIBRARY_VERSION = "otel.library.version";

    private Adapter() {
    }

    static Collection<Model.Span> toJaeger(Collection<SpanData> spans) {
        ArrayList<Model.Span> convertedList = new ArrayList<Model.Span>(spans.size());
        for (SpanData span : spans) {
            convertedList.add(Adapter.toJaeger(span));
        }
        return convertedList;
    }

    static Model.Span toJaeger(SpanData span) {
        Model.Span.Builder target = Model.Span.newBuilder();
        SpanContext spanContext = span.getSpanContext();
        target.setTraceId(ByteString.copyFrom((byte[])spanContext.getTraceIdBytes()));
        target.setSpanId(ByteString.copyFrom((byte[])spanContext.getSpanIdBytes()));
        target.setOperationName(span.getName());
        Timestamp startTimestamp = Timestamps.fromNanos((long)span.getStartEpochNanos());
        target.setStartTime(startTimestamp);
        target.setDuration(Timestamps.between((Timestamp)startTimestamp, (Timestamp)Timestamps.fromNanos((long)span.getEndEpochNanos())));
        target.addAllTags(Adapter.toKeyValues(span.getAttributes()));
        target.addAllLogs(Adapter.toJaegerLogs(span.getEvents()));
        target.addAllReferences(Adapter.toSpanRefs(span.getLinks()));
        SpanContext parentSpanContext = span.getParentSpanContext();
        if (parentSpanContext.isValid()) {
            target.addReferences(Model.SpanRef.newBuilder().setTraceId(ByteString.copyFrom((byte[])parentSpanContext.getTraceIdBytes())).setSpanId(ByteString.copyFrom((byte[])parentSpanContext.getSpanIdBytes())).setRefType(Model.SpanRefType.CHILD_OF));
        }
        if (span.getKind() != SpanKind.INTERNAL) {
            target.addTags(Model.KeyValue.newBuilder().setKey(KEY_SPAN_KIND).setVStr(span.getKind().name().toLowerCase(Locale.ROOT)).build());
        }
        if (span.getStatus().getDescription() != null) {
            target.addTags(Model.KeyValue.newBuilder().setKey(KEY_SPAN_STATUS_MESSAGE).setVStr(span.getStatus().getDescription()).build());
        }
        if (span.getStatus().getStatusCode() != StatusCode.UNSET) {
            target.addTags(Model.KeyValue.newBuilder().setKey(KEY_SPAN_STATUS_CODE).setVStr(span.getStatus().getStatusCode().name()).build());
        }
        target.addTags(Model.KeyValue.newBuilder().setKey(KEY_INSTRUMENTATION_LIBRARY_NAME).setVStr(span.getInstrumentationLibraryInfo().getName()).build());
        if (span.getInstrumentationLibraryInfo().getVersion() != null) {
            target.addTags(Model.KeyValue.newBuilder().setKey(KEY_INSTRUMENTATION_LIBRARY_VERSION).setVStr(span.getInstrumentationLibraryInfo().getVersion()).build());
        }
        if (span.getStatus().getStatusCode() == StatusCode.ERROR) {
            target.addTags(Adapter.toKeyValue(KEY_ERROR, true));
        }
        return target.build();
    }

    @VisibleForTesting
    static Collection<Model.Log> toJaegerLogs(List<EventData> timeEvents) {
        ArrayList<Model.Log> logs = new ArrayList<Model.Log>(timeEvents.size());
        for (EventData e : timeEvents) {
            logs.add(Adapter.toJaegerLog(e));
        }
        return logs;
    }

    @VisibleForTesting
    static Model.Log toJaegerLog(EventData event) {
        Model.Log.Builder builder = Model.Log.newBuilder();
        builder.setTimestamp(Timestamps.fromNanos((long)event.getEpochNanos()));
        builder.addFields(Model.KeyValue.newBuilder().setKey(KEY_LOG_EVENT).setVStr(event.getName()).build());
        int droppedAttributesCount = event.getDroppedAttributesCount();
        if (droppedAttributesCount > 0) {
            builder.addFields(Model.KeyValue.newBuilder().setKey(KEY_EVENT_DROPPED_ATTRIBUTES_COUNT).setVInt64(droppedAttributesCount).build());
        }
        builder.addAllFields(Adapter.toKeyValues(event.getAttributes()));
        return builder.build();
    }

    @VisibleForTesting
    static Collection<Model.KeyValue> toKeyValues(Attributes attributes) {
        ArrayList<Model.KeyValue> tags = new ArrayList<Model.KeyValue>(attributes.size());
        attributes.forEach((key, value) -> tags.add(Adapter.toKeyValue(key, value)));
        return tags;
    }

    @VisibleForTesting
    static Model.KeyValue toKeyValue(AttributeKey<?> key, Object value) {
        Model.KeyValue.Builder builder = Model.KeyValue.newBuilder();
        builder.setKey(key.getKey());
        switch (key.getType()) {
            case STRING: {
                builder.setVStr((String)value);
                builder.setVType(Model.ValueType.STRING);
                break;
            }
            case LONG: {
                builder.setVInt64((Long)value);
                builder.setVType(Model.ValueType.INT64);
                break;
            }
            case BOOLEAN: {
                builder.setVBool((Boolean)value);
                builder.setVType(Model.ValueType.BOOL);
                break;
            }
            case DOUBLE: {
                builder.setVFloat64((Double)value);
                builder.setVType(Model.ValueType.FLOAT64);
                break;
            }
            case STRING_ARRAY: 
            case LONG_ARRAY: 
            case BOOLEAN_ARRAY: 
            case DOUBLE_ARRAY: {
                builder.setVStr(new Gson().toJson(value));
                builder.setVType(Model.ValueType.STRING);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static Collection<Model.SpanRef> toSpanRefs(List<LinkData> links) {
        ArrayList<Model.SpanRef> spanRefs = new ArrayList<Model.SpanRef>(links.size());
        for (LinkData link : links) {
            spanRefs.add(Adapter.toSpanRef(link));
        }
        return spanRefs;
    }

    @VisibleForTesting
    static Model.SpanRef toSpanRef(LinkData link) {
        Model.SpanRef.Builder builder = Model.SpanRef.newBuilder();
        builder.setTraceId(ByteString.copyFrom((byte[])link.getSpanContext().getTraceIdBytes()));
        builder.setSpanId(ByteString.copyFrom((byte[])link.getSpanContext().getSpanIdBytes()));
        builder.setRefType(Model.SpanRefType.FOLLOWS_FROM);
        return builder.build();
    }
}

